/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.ui.docbox.handler;

import at.medevit.elexis.ehc.docbox.service.DocboxService;
import at.medevit.elexis.ehc.ui.docbox.handler.SavePrescriptionUtil;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.data.OutputLog;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rezept;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.ehealth_connector.cda.ch.AbstractCdaChV1;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.slf4j.LoggerFactory;

public class SendPrescriptionHandler
extends AbstractHandler
implements IHandler,
IOutputter {
    private static Image symbol;
    private Rezept prescription;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.prescription = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
        if (this.prescription != null) {
            AbstractCdaChV1 cdaPrescription = null;
            ByteArrayOutputStream pdfPrescription = null;
            ByteArrayOutputStream cdaOutput = new ByteArrayOutputStream();
            try {
                cdaPrescription = DocboxService.getPrescriptionDocument((Rezept)this.prescription);
                try {
                    CDAUtil.save((ClinicalDocument)cdaPrescription.getDocRoot().getClinicalDocument(), (OutputStream)cdaOutput);
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating InputStream for sending", (Throwable)ex);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Das Rezept konnte nicht erstellt werden. " + ex.getMessage()));
                    return null;
                }
            }
            catch (IllegalStateException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Das Rezept konnte nicht erstellt werden. " + e.getMessage()));
                return null;
            }
            pdfPrescription = DocboxService.getPrescriptionPdf((ByteArrayOutputStream)cdaOutput);
            if (cdaPrescription != null && pdfPrescription != null) {
                ByteArrayInputStream pdfInput;
                ByteArrayInputStream cdaInput = new ByteArrayInputStream(cdaOutput.toByteArray());
                String message = DocboxService.sendPrescription((InputStream)cdaInput, (InputStream)(pdfInput = new ByteArrayInputStream(pdfPrescription.toByteArray())));
                if (!message.startsWith("FAILED")) {
                    SavePrescriptionUtil.savePrescription(this.prescription, "pdf", pdfPrescription.toByteArray());
                    new OutputLog((PersistentObject)this.prescription, (IOutputter)this);
                    try {
                        Program.launch((String)this.writeTempPdf(pdfPrescription));
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Das Rezept konnte nicht angezeigt werden.");
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Das Rezept konnte nicht gesendet werden. R\u00fcckmeldung:\n\n" + message));
                }
                return null;
            }
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Das Rezept konnte nicht gesendet werden.");
        return null;
    }

    private String writeTempPdf(ByteArrayOutputStream pdf) throws FileNotFoundException, IOException {
        File pdfFile = File.createTempFile(this.getRezeptFileName(), ".pdf");
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream fos = new FileOutputStream(pdfFile);){
            fos.write(pdf.toByteArray());
            fos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return pdfFile.getAbsolutePath();
    }

    public String getRezeptFileName() {
        String ret = this.prescription.getLabel();
        return ret.replaceAll(" ", "_");
    }

    public String getOutputterID() {
        return "at.medevit.elexis.ehc.ui.docbox.outputter";
    }

    public String getOutputterDescription() {
        return "Rezept\u00fcbermittlung an Docbox";
    }

    public Image getSymbol() {
        if (symbol == null) {
            ImageDescriptor iDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"at.medevit.elexis.ehc.ui.docbox", (String)"/icons/docbox16.png");
            symbol = iDesc.createImage();
        }
        return symbol;
    }
}

