/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.core.internal;

import at.medevit.elexis.ehc.core.EhcCoreMapper;
import at.medevit.elexis.ehc.core.EhcCoreService;
import at.medevit.elexis.ehc.core.internal.document.CdaChImpl;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.ehealth_connector.cda.ch.AbstractCdaChV1;
import org.ehealth_connector.communication.ConvenienceCommunication;
import org.ehealth_connector.communication.DocumentMetadata;
import org.ehealth_connector.communication.xd.xdm.DocumentContentAndMetadata;
import org.ehealth_connector.communication.xd.xdm.XdmContents;
import org.openhealthtools.ihe.xds.document.DocumentDescriptor;
import org.openhealthtools.ihe.xds.document.XDSDocument;
import org.openhealthtools.mdht.uml.cda.ClinicalDocument;
import org.openhealthtools.mdht.uml.cda.RecordTarget;
import org.openhealthtools.mdht.uml.cda.ch.ChFactory;
import org.openhealthtools.mdht.uml.cda.util.CDAUtil;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class EhcCoreServiceImpl
implements EhcCoreService {
    private static Logger logger = LoggerFactory.getLogger(EhcCoreServiceImpl.class);

    public EhcCoreServiceImpl() {
        ChFactory.eINSTANCE.createCdaChV1().init();
    }

    @Override
    public AbstractCdaChV1<?> createCdaChDocument(Patient patient, Mandant mandant) {
        CdaChImpl ret = new CdaChImpl((ClinicalDocument)ChFactory.eINSTANCE.createCdaChV1().init());
        ret.setPatient(EhcCoreMapper.getEhcPatient(patient));
        ret.addAuthor(EhcCoreMapper.getEhcAuthor(mandant));
        return ret;
    }

    @Override
    public ClinicalDocument loadDocument(InputStream document) {
        try {
            return CDAUtil.load((InputStream)document);
        }
        catch (Exception e) {
            logger.warn("Error loading document.", (Throwable)e);
            return null;
        }
    }

    @Override
    public AbstractCdaChV1<?> getAsCdaChDocument(ClinicalDocument clinicalDocument) {
        if (clinicalDocument instanceof ClinicalDocument) {
            return new CdaChImpl(clinicalDocument);
        }
        return null;
    }

    @Override
    public Patient getOrCreatePatient(org.ehealth_connector.common.Patient ehcPatient) {
        Patient patient = EhcCoreMapper.getElexisPatient(ehcPatient);
        EhcCoreMapper.importEhcAddress((Kontakt)patient, ehcPatient.getAddress());
        EhcCoreMapper.importEhcPhone((Kontakt)patient, ehcPatient.getTelecoms());
        return patient;
    }

    @Override
    public InputStream getXdmAsStream(ClinicalDocument document) throws Exception {
        ConvenienceCommunication conCom = new ConvenienceCommunication();
        ByteArrayOutputStream outputStream = null;
        outputStream = new ByteArrayOutputStream();
        CDAUtil.save((ClinicalDocument)document, (OutputStream)outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        outputStream.reset();
        DocumentMetadata metaData = conCom.addDocument(DocumentDescriptor.CDA_R2, (InputStream)inputStream);
        metaData.setPatient(this.getPatient(document));
        conCom.createXdmContents((OutputStream)outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private org.ehealth_connector.common.Patient getPatient(ClinicalDocument document) {
        EList targets = document.getRecordTargets();
        if (targets != null && !targets.isEmpty()) {
            if (targets.size() > 1) {
                logger.warn("Document " + document.getTitle() + " has more than one record target");
            }
            return new org.ehealth_connector.common.Patient((RecordTarget)EcoreUtil.copy((EObject)((RecordTarget)targets.get(0))));
        }
        throw new IllegalStateException("Document " + document.getTitle() + " has no record target");
    }

    @Override
    public List<ClinicalDocument> getXdmDocuments(File file) {
        ArrayList<ClinicalDocument> ret = null;
        ConvenienceCommunication conCom = new ConvenienceCommunication();
        XdmContents contents = conCom.getXdmContents(file.getAbsolutePath());
        if (contents != null) {
            ret = new ArrayList<ClinicalDocument>();
            List dataList = contents.getDocumentAndMetadataList();
            for (DocumentContentAndMetadata documentContentAndMetadata : dataList) {
                XDSDocument xdsDocument = documentContentAndMetadata.getXdsDocument();
                if (xdsDocument == null) continue;
                try {
                    ClinicalDocument clinicalDocument = CDAUtil.load((InputStream)xdsDocument.getStream());
                    if (clinicalDocument == null) continue;
                    ret.add(clinicalDocument);
                }
                catch (Exception e) {
                    logger.error("Could not load document " + xdsDocument.getNewDocumentUniqueId() + " from xdm " + file.getAbsolutePath());
                }
            }
        }
        return ret;
    }

    @Override
    public List<org.ehealth_connector.common.Patient> getXdmPatients(File file) {
        ArrayList<org.ehealth_connector.common.Patient> ret = null;
        ConvenienceCommunication conCom = new ConvenienceCommunication();
        XdmContents contents = conCom.getXdmContents(file.getAbsolutePath());
        if (contents != null) {
            ret = new ArrayList<org.ehealth_connector.common.Patient>();
            List dataList = contents.getDocumentAndMetadataList();
            for (DocumentContentAndMetadata documentContentAndMetadata : dataList) {
                ret.add(documentContentAndMetadata.getDocEntry().getPatient());
            }
        }
        return ret;
    }

    @Override
    public String createXdmContainer(Patient patient, Mandant mandant, List<File> attachments, String xdmPath) {
        if (patient != null && mandant != null && attachments != null && xdmPath != null) {
            ConvenienceCommunication conCom = new ConvenienceCommunication();
            org.ehealth_connector.common.Patient ehealthPatient = EhcCoreMapper.getEhcPatient(patient);
            StringBuilder retInfo = new StringBuilder();
            retInfo.append(xdmPath);
            for (File f : attachments) {
                try {
                    if (f.exists()) {
                        String attachmentPath = f.getAbsolutePath();
                        DocumentDescriptor dc = null;
                        dc = attachmentPath.toLowerCase().endsWith("xml") ? (this.isCdaDocument(f) ? DocumentDescriptor.CDA_R2 : DocumentDescriptor.XML) : (attachmentPath.toLowerCase().endsWith("pdf") ? DocumentDescriptor.PDF : new DocumentDescriptor(FilenameUtils.getExtension((String)attachmentPath), Files.probeContentType(f.toPath())));
                        FileInputStream in = FileUtils.openInputStream((File)f);
                        DocumentMetadata metaData = conCom.addDocument(dc, (InputStream)in);
                        metaData.setPatient(ehealthPatient);
                        IOUtils.closeQuietly((InputStream)in);
                        retInfo.append(":::");
                        retInfo.append(attachmentPath);
                        continue;
                    }
                    LoggerFactory.getLogger(EhcCoreService.class).warn("creating xdm - patient [{}] - file does not exists [{}]", (Object)patient.getId(), (Object)f.getAbsolutePath());
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(EhcCoreService.class).error("creating xdm - patient [{}] - cannot add file [{}]", new Object[]{patient.getId(), f.getAbsolutePath(), e});
                }
            }
            try {
                conCom.createXdmContents(xdmPath);
                if (retInfo.toString().contains(":::")) {
                    return retInfo.toString();
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(EhcCoreService.class).error("creating xdm - patient [{}] - cannot create xdm contents", (Object)patient.getId(), (Object)e);
            }
        }
        return null;
    }

    @Override
    public boolean isCdaDocument(File file) {
        if (file != null) {
            try {
                FileInputStream in = FileUtils.openInputStream((File)file);
                ClinicalDocument c = CDAUtil.load((InputStream)in);
                IOUtils.closeQuietly((InputStream)in);
                return c != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

