/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.ehc.core;

import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.Anschrift;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnungssteller;
import ch.elexis.data.Xid;
import ch.rgw.tools.TimeTool;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ehealth_connector.common.Address;
import org.ehealth_connector.common.Author;
import org.ehealth_connector.common.Identificator;
import org.ehealth_connector.common.Name;
import org.ehealth_connector.common.Organization;
import org.ehealth_connector.common.Telecoms;
import org.ehealth_connector.common.enums.AddressUse;
import org.ehealth_connector.common.enums.AdministrativeGender;
import org.ehealth_connector.common.enums.CodeSystems;

public class EhcCoreMapper {
    private static TimeTool timeTool = new TimeTool();
    private static final Pattern lastIntPattern = Pattern.compile("[^0-9]+([0-9]+)[a-z]?$");

    public static Name getEhcName(String name) {
        String[] parts = name.split(" ");
        if (parts.length == 1) {
            return new Name("", parts[0]);
        }
        if (parts.length == 2) {
            return new Name(parts[0], parts[1]);
        }
        if (parts.length >= 3) {
            return new Name(parts[0], parts[1], parts[2]);
        }
        return new Name("", "");
    }

    public static org.ehealth_connector.common.Patient getEhcPatient(Patient elexisPatient) {
        String socialSecurityNumber;
        org.ehealth_connector.common.Patient ret = new org.ehealth_connector.common.Patient(EhcCoreMapper.getEhcPersonName((Person)elexisPatient), EhcCoreMapper.getEhcGenderCode((Person)elexisPatient), EhcCoreMapper.getDate(elexisPatient.getGeburtsdatum()));
        Telecoms telecoms = new Telecoms();
        String value = elexisPatient.get("Telefon1");
        if (value != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            telecoms.addPhone(value, AddressUse.PRIVATE);
        }
        if ((value = elexisPatient.get("NatelNr")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            telecoms.addPhone(value, AddressUse.MOBILE);
        }
        ret.setTelecoms(telecoms);
        Anschrift elexisAddress = elexisPatient.getAnschrift();
        if (elexisAddress != null) {
            ret.addAddress(EhcCoreMapper.getEhcAddress(elexisAddress));
        }
        if ((socialSecurityNumber = elexisPatient.getXid("www.ahv.ch/xid")) != null) {
            socialSecurityNumber = socialSecurityNumber.trim();
            if ((socialSecurityNumber = socialSecurityNumber.replaceAll("\\.", "")).length() == 11) {
                ret.addId(new Identificator(CodeSystems.SwissSSNDeprecated.getCodeSystemId(), socialSecurityNumber));
            } else if (socialSecurityNumber.length() == 13) {
                ret.addId(new Identificator(CodeSystems.SwissSSN.getCodeSystemId(), socialSecurityNumber));
            }
        }
        return ret;
    }

    public static Address getEhcAddress(Anschrift elexisAddress) {
        String elexisStreet = elexisAddress.getStrasse();
        String houseNumber = "";
        Matcher matcher = lastIntPattern.matcher(elexisStreet);
        if (matcher.find()) {
            houseNumber = matcher.group(1);
            elexisStreet = elexisStreet.substring(0, matcher.start(1));
        }
        Address ehcAddress = new Address(elexisStreet.trim(), houseNumber, elexisAddress.getPlz(), elexisAddress.getOrt());
        ehcAddress.setAddressline1(elexisAddress.getStrasse());
        return ehcAddress;
    }

    public static Author getEhcAuthor(Mandant elexisMandant) {
        String gln = elexisMandant.getXid("www.xid.ch/id/ean");
        Author ret = new Author(EhcCoreMapper.getEhcPersonName((Person)elexisMandant), gln);
        if (gln != null) {
            ret.addId(new Identificator("1.3.88", gln));
        }
        Telecoms telecoms = new Telecoms();
        String value = elexisMandant.get("Telefon1");
        if (value != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            telecoms.addPhone(value, AddressUse.PRIVATE);
        }
        if ((value = elexisMandant.get("NatelNr")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            telecoms.addPhone(value, AddressUse.MOBILE);
        }
        ret.setTelecoms(telecoms);
        Anschrift elexisAddress = elexisMandant.getAnschrift();
        if (elexisAddress != null) {
            ret.addAddress(EhcCoreMapper.getEhcAddress(elexisAddress));
        }
        return ret;
    }

    public static Organization getEhcOrganization(Mandant elexisMandant) {
        Rechnungssteller rechnungssteller = elexisMandant.getRechnungssteller();
        String gln = rechnungssteller.getXid("www.xid.ch/id/ean");
        Organization ret = new Organization(rechnungssteller.getLabel(), gln);
        Telecoms telecoms = new Telecoms();
        String value = rechnungssteller.get("Telefon1");
        if (value != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            telecoms.addPhone(value, AddressUse.PRIVATE);
        }
        if ((value = rechnungssteller.get("NatelNr")) != null && !value.isEmpty() && !value.equalsIgnoreCase("0")) {
            telecoms.addPhone(value, AddressUse.MOBILE);
        }
        ret.setTelecoms(telecoms);
        Anschrift elexisAddress = rechnungssteller.getAnschrift();
        if (elexisAddress != null) {
            ret.addAddress(EhcCoreMapper.getEhcAddress(elexisAddress));
        }
        return ret;
    }

    public static Name getEhcPersonName(Person elexisPerson) {
        Name ret = new Name(elexisPerson.getVorname(), elexisPerson.getName(), elexisPerson.get("Titel"));
        return ret;
    }

    public static AdministrativeGender getEhcGenderCode(Person elexisPerson) {
        if (elexisPerson.getGeschlecht().equals("w")) {
            return AdministrativeGender.FEMALE;
        }
        if (elexisPerson.getGeschlecht().equals("m")) {
            return AdministrativeGender.MALE;
        }
        return AdministrativeGender.UNDIFFERENTIATED;
    }

    public static Date getDate(String elexisDate) {
        timeTool.set(elexisDate);
        return timeTool.getTime();
    }

    public static Patient getElexisPatient(org.ehealth_connector.common.Patient ehcPatient) {
        List ids = ehcPatient.getIds();
        for (Identificator identificator : ids) {
            String idRoot = identificator.getRoot();
            if (!idRoot.equals(CodeSystems.SwissSSNDeprecated.getCodeSystemId()) && !idRoot.equals(CodeSystems.SwissSSN.getCodeSystemId())) continue;
            IPersistentObject ret = Xid.findObject((String)"www.ahv.ch/xid", (String)identificator.getExtension());
            if (ret instanceof Kontakt && ((Kontakt)ret).istPatient()) {
                return Patient.load((String)ret.getId());
            }
            System.out.println("foud ret " + ret);
            if (!(ret instanceof Patient)) continue;
            return (Patient)ret;
        }
        Query qpa = new Query(Patient.class);
        Name ehcName = ehcPatient.getName();
        Date ehcBirthdate = ehcPatient.getBirthday();
        String gender = ehcPatient.getAdministrativeGenderCode() == AdministrativeGender.FEMALE ? "w" : "m";
        TimeTool ttBirthdate = new TimeTool();
        if (ehcName.getFamilyName() != null && !ehcName.getFamilyName().isEmpty()) {
            qpa.add("Name", "=", ehcName.getFamilyName());
        }
        if (ehcName.getGivenNames() != null && !ehcName.getGivenNames().isEmpty()) {
            qpa.add("Vorname", "=", (String)ehcName.getGivenNames().get(0));
        }
        if (ehcBirthdate != null) {
            ttBirthdate.setTime(ehcBirthdate);
            qpa.add("Geburtsdatum", "=", ttBirthdate.toString(9));
        }
        List existing = qpa.execute();
        Patient ret = null;
        ret = existing.isEmpty() ? new Patient(ehcName.getFamilyName(), (String)ehcName.getGivenNames().get(0), ttBirthdate.toString(9), gender) : (Patient)existing.get(0);
        return ret;
    }

    public static void importEhcAddress(Kontakt kontakt, Address address) {
        Anschrift elexisAddress = kontakt.getAnschrift();
        elexisAddress.setOrt(address.getCity());
        elexisAddress.setPlz(address.getZip());
        elexisAddress.setStrasse(String.valueOf(address.getStreet()) + " " + address.getHouseNumber());
        kontakt.setAnschrift(elexisAddress);
    }

    public static void importEhcPhone(Kontakt kontakt, Telecoms telecoms) {
        Map phones = telecoms.getPhones();
        Set keys = phones.keySet();
        String existing = kontakt.get("Telefon1");
        for (String key : keys) {
            if (key.equals(existing)) continue;
            if (existing == null || existing.isEmpty()) {
                kontakt.set("Telefon1", key);
                continue;
            }
            kontakt.set("Telefon2", key);
        }
    }
}

