/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.ui;

import at.medevit.elexis.cobasmira.Messages;
import at.medevit.elexis.cobasmira.connection.CobasMiraConnection;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = LoggerFactory.getLogger(Preferences.class);
    public static final String COBASMIRA_BASE = "connectors/cobasmira/";
    public static final String PORT = "connectors/cobasmira/port";
    public static final String TIMEOUT = "connectors/cobasmira/timeout";
    public static final String PARAMS = "connectors/cobasmira/params";
    public static final String LOG = "connectors/cobasmira/log";
    public static final String BACKGROUND = "connectors/cobasmira/background";
    public static final String CONTROLUSER = "connectors/cobasmira/ignoreuser";
    public static final String LABIDENTIFICATION = "connectors/cobasmira/labidentification";
    public static final String MAPPINGSCSVFILE = "connectors/cobasmira/csvmappingsfile";
    public static final String ERRORMSGRECEIVER = "connectors/cobasmira/errMsgReceiver";
    public static final String CONTROLLOGFILE = "connectors/cobasmira/controlLogFile";
    Combo ports;
    Combo databits;
    Combo stopbits;
    Combo parity;
    Combo flowctrlIn;
    Combo flowctrlOut;
    int selected;
    private Text labIdentification;
    private Text controlUser;
    private Text speed;
    private Button automaticStart;
    private Text mappingLoc;
    private Text controlLogLoc;

    public Preferences() {
        super(Messages.CobasMiraAction_ButtonName);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
        this.initMappingFileLocation();
    }

    protected Control createContents(Composite parent) {
        String[] param = CoreHub.localCfg.get(PARAMS, "1200,7,None,2,1,2").split(",");
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(4, false));
        Label lblLabIdentification = new Label(ret, 0);
        lblLabIdentification.setText(Messages.Preferences_LabIdentification);
        lblLabIdentification.setLayoutData((Object)new GridData(0));
        String labIdentificationStr = CoreHub.localCfg.get(LABIDENTIFICATION, Messages.CobasMiraAction_OwnLabIdentification);
        this.labIdentification = new Text(ret, 2048);
        this.labIdentification.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.labIdentification.setText(labIdentificationStr);
        Label lblIgnoreUser = new Label(ret, 0);
        lblIgnoreUser.setText(Messages.Preferences_IgnoreUserOnInput);
        lblIgnoreUser.setLayoutData((Object)new GridData(0));
        String controlUserStr = CoreHub.localCfg.get(CONTROLUSER, Messages.CobasMiraAction_DefaultIgnoreUser);
        this.controlUser = new Text(ret, 2048);
        this.controlUser.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.controlUser.setText(controlUserStr);
        Label lblControlLogLoc = new Label(ret, 0);
        lblControlLogLoc.setText(Messages.Preferences_lblcontrolLogLoc);
        lblControlLogLoc.setLayoutData((Object)new GridData(0));
        String controlLogLocStr = CoreHub.localCfg.get(CONTROLLOGFILE, Messages.Message_notset);
        this.controlLogLoc = new Text(ret, 2048);
        this.controlLogLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.controlLogLoc.setText(controlLogLocStr);
        Label lblMappingLoc = new Label(ret, 0);
        lblMappingLoc.setText(Messages.Preferences_lblMappingDatei);
        lblMappingLoc.setLayoutData((Object)new GridData(0));
        String mappingLocStr = CoreHub.localCfg.get(MAPPINGSCSVFILE, Messages.Message_notset);
        this.mappingLoc = new Text(ret, 2048);
        this.mappingLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mappingLoc.setText(mappingLocStr);
        Button btnBrowse = new Button(ret, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Preferences.this.getShell(), 4096);
                String selected = fd.open();
                Preferences.this.mappingLoc.setText(selected);
            }
        });
        btnBrowse.setText(Messages.Preferences_btnBrowse_text);
        Label lblPorts = new Label(ret, 0);
        lblPorts.setText(Messages.Preferences_Port);
        lblPorts.setLayoutData((Object)new GridData(0));
        this.ports = new Combo(ret, 4);
        this.ports.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.ports.setItems(CobasMiraConnection.getComPorts());
        this.ports.setText(CoreHub.localCfg.get(PORT, Messages.CobasMiraAction_DefaultPort));
        Label lblSpeed = new Label(ret, 0);
        lblSpeed.setText(Messages.Preferences_Baud);
        lblSpeed.setLayoutData((Object)new GridData(0));
        this.speed = new Text(ret, 2048);
        GridData gd_speed = new GridData(768);
        gd_speed.horizontalSpan = 3;
        this.speed.setLayoutData((Object)gd_speed);
        this.speed.setText(param[0]);
        Label lblDatabits = new Label(ret, 0);
        lblDatabits.setText(Messages.Preferences_Databits);
        lblDatabits.setLayoutData((Object)new GridData(0));
        this.databits = new Combo(ret, 4);
        this.databits.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.databits.add("5");
        this.databits.add("6");
        this.databits.add("7");
        this.databits.add("8");
        this.databits.setText(param[1]);
        Label lblParity = new Label(ret, 0);
        lblParity.setText(Messages.Preferences_Parity);
        lblParity.setLayoutData((Object)new GridData(0));
        this.parity = new Combo(ret, 4);
        this.parity.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.parity.add("None");
        this.parity.add("Even");
        this.parity.add("Odd");
        this.parity.setText(param[2]);
        Label lblStopbits = new Label(ret, 0);
        lblStopbits.setText(Messages.Preferences_Stopbits);
        lblStopbits.setLayoutData((Object)new GridData(0));
        this.stopbits = new Combo(ret, 4);
        this.stopbits.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.stopbits.add("1");
        this.stopbits.add("2");
        this.stopbits.setText(param[3]);
        Label lblflowctrlIn = new Label(ret, 0);
        lblflowctrlIn.setText(Messages.Preferences_FlowCtrlIn);
        lblflowctrlIn.setLayoutData((Object)new GridData(0));
        this.flowctrlIn = new Combo(ret, 4);
        this.flowctrlIn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.flowctrlIn.add("NONE");
        this.flowctrlIn.add("RTSCTS");
        this.flowctrlIn.add("XONXOFF");
        if (param.length > 4) {
            this.selected = Integer.parseInt(param[4]);
            if (this.selected == 0) {
                this.flowctrlIn.setText("NONE");
            }
            if (this.selected == 1) {
                this.flowctrlIn.setText("RTSCTS");
            }
            if (this.selected == 4) {
                this.flowctrlIn.setText("XONXOFF");
            }
        }
        Label lblflowctrlOut = new Label(ret, 0);
        lblflowctrlOut.setText(Messages.Preferences_FlowCtrlOut);
        lblflowctrlOut.setLayoutData((Object)new GridData(0));
        this.flowctrlOut = new Combo(ret, 4);
        this.flowctrlOut.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.flowctrlOut.add("NONE");
        this.flowctrlOut.add("RTSCTS");
        this.flowctrlOut.add("XONXOFF");
        if (param.length > 5) {
            this.selected = Integer.parseInt(param[5]);
            if (this.selected == 0) {
                this.flowctrlOut.setText("NONE");
            }
            if (this.selected == 2) {
                this.flowctrlOut.setText("RTSCTS");
            }
            if (this.selected == 8) {
                this.flowctrlOut.setText("XONXOFF");
            }
        }
        new Label(ret, 0).setText(Messages.Preferences_Backgroundprocess);
        this.automaticStart = new Button(ret, 32);
        this.automaticStart.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.automaticStart.setSelection(CoreHub.localCfg.get(BACKGROUND, "n").equalsIgnoreCase("y"));
        return ret;
    }

    public void init(IWorkbench arg0) {
    }

    private void initMappingFileLocation() {
        String cobasMappingCSV = CoreHub.localCfg.get(MAPPINGSCSVFILE, null);
        if (cobasMappingCSV == null) {
            cobasMappingCSV = Preferences.getDefaultMappingCSVLocation();
        }
        Preferences.setOrCreateMappingCSV(cobasMappingCSV);
    }

    private static void setOrCreateMappingCSV(String path) {
        try {
            File csv = new File(path);
            if (!csv.exists()) {
                int length;
                csv.getParentFile().mkdirs();
                csv.createNewFile();
                InputStream sourceStream = Preferences.class.getResourceAsStream("/rsc/cmmli.csv");
                FileOutputStream destStream = new FileOutputStream(csv);
                byte[] buffer = new byte[1024];
                while ((length = sourceStream.read(buffer)) > 0) {
                    destStream.write(buffer, 0, length);
                }
                sourceStream.close();
                destStream.close();
            }
            CoreHub.localCfg.set(MAPPINGSCSVFILE, csv.getAbsolutePath());
        }
        catch (IOException ioe) {
            logger.error("Unable to initialize CobasMira base mapping csv", (Throwable)ioe);
        }
    }

    public static String getDefaultMappingCSVLocation() {
        String csv_file = CoreHub.getWritableUserDir() + File.separator + "cobasMira" + File.separator + "cmmli.csv";
        Preferences.setOrCreateMappingCSV(csv_file);
        return csv_file;
    }

    public boolean performOk() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.speed.getText()).append(",").append(this.databits.getText()).append(",").append(this.parity.getText()).append(",").append(this.stopbits.getText());
        if (this.flowctrlIn.getText().equals("NONE")) {
            sb.append(",0");
        } else if (this.flowctrlIn.getText().equals("RTSCTS")) {
            sb.append(",1");
        } else if (this.flowctrlIn.getText().equals("XONXOFF")) {
            sb.append(",4");
        }
        if (this.flowctrlOut.getText().equals("NONE")) {
            sb.append(",0");
        } else if (this.flowctrlOut.getText().equals("RTSCTS")) {
            sb.append(",2");
        } else if (this.flowctrlOut.getText().equals("XONXOFF")) {
            sb.append(",8");
        }
        CoreHub.localCfg.set(CONTROLUSER, this.controlUser.getText().trim());
        CoreHub.localCfg.set(PARAMS, sb.toString());
        CoreHub.localCfg.set(PORT, this.ports.getText());
        CoreHub.localCfg.set(BACKGROUND, this.automaticStart.getSelection() ? "y" : "n");
        CoreHub.localCfg.set(LABIDENTIFICATION, this.labIdentification.getText());
        CoreHub.localCfg.set(MAPPINGSCSVFILE, this.mappingLoc.getText());
        CoreHub.localCfg.set(CONTROLLOGFILE, this.controlLogLoc.getText());
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

