/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.resulthandler;

import at.medevit.elexis.cobasmira.model.CobasMiraMapping;
import at.medevit.elexis.cobasmira.model.CobasMiraMessage;
import at.medevit.elexis.cobasmira.model.CobasMiraPatientResult;
import at.medevit.elexis.cobasmira.resulthandler.ControlResultHandler;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportPatientResult {
    private static Logger logger = LoggerFactory.getLogger(ImportPatientResult.class);

    public static int importPatientResult(CobasMiraMessage msg) {
        TimeTool resultDate = msg.getEntryDate();
        LinkedList<CobasMiraPatientResult> patientResults = msg.getPatientResults();
        logger.debug(resultDate + " Handling " + patientResults.size() + " results.");
        for (CobasMiraPatientResult coMiPaRe : patientResults) {
            String kontrollePatientID;
            String labitemID = CobasMiraMapping.getId(coMiPaRe.getTestName());
            LabItem l = LabItem.load((String)labitemID);
            if (!l.exists()) {
                logger.warn("LabItem ID " + labitemID + " could not be loaded.");
                if (patientResults.size() != 1) continue;
                return CobasMiraMessage.ELEXIS_RESULT_LABITEM_NOT_FOUND;
            }
            String patientElexisID = coMiPaRe.getPatientIdentification();
            if (patientElexisID.equalsIgnoreCase(kontrollePatientID = CoreHub.localCfg.get("connectors/cobasmira/ignoreuser", "KO").trim())) {
                int ret = ControlResultHandler.writeControlResult(coMiPaRe, msg.getEntryDate());
                if (patientResults.size() != 1) continue;
                return ret;
            }
            String patID = new Query(Patient.class).findSingle("PatientNr", "=", patientElexisID);
            Patient p = Patient.load((String)patID);
            if (!p.exists()) {
                logger.warn("Patient " + patientElexisID + " could not be loaded.");
                if (patientResults.size() != 1) continue;
                return CobasMiraMessage.ELEXIS_RESULT_PATIENT_NOT_FOUND;
            }
            Query labResult = new Query(LabResult.class);
            labResult.add("ItemID", "=", labitemID);
            labResult.and();
            labResult.add("Datum", "=", resultDate.toString(4));
            labResult.and();
            labResult.add("PatientID", "=", coMiPaRe.getPatientIdentification());
            List labResults = labResult.execute();
            if (labResults.size() == 0) {
                int noDecPlaces = CobasMiraMapping.getNoDecPlaces(coMiPaRe.getTestName());
                Float result = Float.valueOf(ImportPatientResult.roundToDecimals(coMiPaRe.getConcentration(), noDecPlaces));
                LabResult lr = noDecPlaces == 0 ? new LabResult(p, resultDate, l, Integer.toString(result.intValue()), "") : new LabResult(p, resultDate, l, result.toString(), "");
                lr.set("Quelle", l.getLabor().getKuerzel());
                lr.setFlag(0, true);
                continue;
            }
            if (labResults.size() == 1) {
                logger.warn("We already have an entry for " + labResults);
                return 117;
            }
            logger.warn("Invalid number of entries (" + labResults.size() + ") for " + labResults);
        }
        return CobasMiraMessage.ELEXIS_RESULT_INTEGRATION_OK;
    }

    public static float roundToDecimals(float d, int c) {
        if (c == 0) {
            return Math.round(d);
        }
        BigDecimal l_bd = new BigDecimal(d);
        l_bd = l_bd.setScale(c, 4);
        return l_bd.floatValue();
    }
}

