/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.model;

import at.medevit.elexis.cobasmira.model.CobasMiraErrorMessage;
import at.medevit.elexis.cobasmira.model.CobasMiraPatientResult;
import ch.rgw.tools.TimeTool;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobasMiraMessage {
    private static Logger logger = LoggerFactory.getLogger(CobasMiraMessage.class);
    public static int BLOCK_TYPE_NOBLOCK_IDLEBLOCK = 0;
    public static int BLOCK_TYPE_PATIENT_RESULTS = 3;
    public static int BLOCK_TYPE_ERROR_MESSAGE = 71;
    public static int BLOCK_TYPE_RACK_INFORMATION = 70;
    public static int ELEXIS_RESULT_IGNORED = 112;
    public static int ELEXIS_RESULT_INTEGRATION_OK = 113;
    public static int ELEXIS_RESULT_PATIENT_NOT_FOUND = 114;
    public static int ELEXIS_RESULT_LABITEM_NOT_FOUND = 115;
    public static int ELEXIS_RESULT_CONTROL_OK = 116;
    public static final int ELEXIS_RESULT_RESULT_ALREADY_HERE = 117;
    public static int ELEXIS_RESULT_CONTROL_ERR = 118;
    private int instrumentCode;
    private int blockType;
    private int elexisState = 0;
    private String systemIdentification;
    private TimeTool entryDate;
    private LinkedList<CobasMiraPatientResult> patientResults = new LinkedList();
    private CobasMiraErrorMessage errMessage = null;

    public CobasMiraMessage() {
        this.entryDate = new TimeTool();
    }

    public LinkedList<CobasMiraPatientResult> getPatientResults() {
        return this.patientResults;
    }

    public TimeTool getEntryDate() {
        return this.entryDate;
    }

    public int getBlockType() {
        return this.blockType;
    }

    public void setHeader(String in) {
        try {
            String header = in.trim();
            this.instrumentCode = Integer.parseInt(header.substring(0, 2));
            this.systemIdentification = header.substring(3, 19).trim();
            this.blockType = Integer.parseInt(header.substring(20, 22));
            logger.debug("HEADER instrumentCode/sysId/blockType: " + this.instrumentCode + "/" + this.systemIdentification + "/" + this.blockType);
        }
        catch (NumberFormatException e) {
            logger.error("Error parsing String: " + in + " due to ", (Throwable)e);
        }
    }

    public void setText(String in) {
        String[] results = in.trim().split("\n");
        logger.debug("setText(), blockType=" + this.blockType + " results.length: " + results.length);
        int i = 0;
        while (i < results.length) {
            logger.debug("(for) i:" + i + " " + this.blockType + "==" + BLOCK_TYPE_PATIENT_RESULTS);
            if (this.blockType == BLOCK_TYPE_PATIENT_RESULTS) {
                logger.debug("Adding patientResult: " + results[i]);
                this.patientResults.add(new CobasMiraPatientResult(results[i]));
            } else if (this.blockType == BLOCK_TYPE_ERROR_MESSAGE) {
                logger.debug("Got error Message");
                this.errMessage = new CobasMiraErrorMessage(results[i]);
            } else {
                logger.warn("No valid Message type.");
            }
            ++i;
        }
    }

    public String getBlockTypeString() {
        return CobasMiraMessage.getBlockTypeString(this.getBlockType());
    }

    public static String getBlockTypeString(int blockType) {
        switch (blockType) {
            case 0: {
                return "No block, idle block";
            }
            case 1: {
                return "Calibration and control results";
            }
            case 3: {
                return "Patient results";
            }
            case 5: {
                return "Quality control results";
            }
            case 10: {
                return "Worklist input";
            }
            case 11: {
                return "Worklist input confirmation";
            }
            case 15: {
                return "Worklist deletion";
            }
            case 16: {
                return "Worklist deletion confirmation";
            }
            case 70: {
                return "Rack information";
            }
            case 71: {
                return "Error message";
            }
            case 94: {
                return "Instrument control";
            }
            case 95: {
                return "Instrument initialization";
            }
        }
        return "Unknown block type";
    }

    public int getNoPatientResults() {
        return this.patientResults.size();
    }

    public String getErrorMessageString() {
        if (this.errMessage != null) {
            return this.errMessage.getErrorDescription();
        }
        return "";
    }

    public int getElexisStatus() {
        return this.elexisState;
    }

    public void setElexisStatus(int elst) {
        this.elexisState = elst;
    }

    public String getSinglePatientResultInfo() {
        if (this.getNoPatientResults() == 1) {
            String testName = this.patientResults.get(0).getTestName();
            float testResult = this.patientResults.get(0).getConcentration();
            String patientID = this.patientResults.get(0).getPatientIdentification();
            return String.valueOf(patientID) + " " + testName + " " + testResult;
        }
        return "More than 1 result contained";
    }

    public int getInstrumentCode() {
        return this.instrumentCode;
    }

    public String getSystemIdentification() {
        return this.systemIdentification;
    }
}

