/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.model;

import at.medevit.elexis.cobasmira.Activator;
import at.medevit.elexis.cobasmira.model.CobasMiraMappingLabitem;
import at.medevit.elexis.cobasmira.ui.Preferences;
import au.com.bytecode.opencsv.bean.ColumnPositionMappingStrategy;
import au.com.bytecode.opencsv.bean.CsvToBean;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import ch.elexis.core.data.activator.CoreHub;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class CobasMiraMapping {
    public static final String CSV_FORMAT = "testNameCM,testNameShort,TestName,laborwertID,refM,refW,noDecPlaces";
    protected static List<CobasMiraMappingLabitem> cobasMappings;

    public static List<CobasMiraMappingLabitem> getCmmappings() {
        if (cobasMappings == null) {
            CobasMiraMapping.initializeMapping();
        }
        return cobasMappings;
    }

    public static void initializeMapping() {
        cobasMappings = new ArrayList<CobasMiraMappingLabitem>();
        String csvFilename = CoreHub.localCfg.get("connectors/cobasmira/csvmappingsfile", Preferences.getDefaultMappingCSVLocation());
        try {
            CsvToBean csvBean = new CsvToBean();
            List csvList = csvBean.parse((MappingStrategy)CobasMiraMapping.getMappingStrategy(), (Reader)new FileReader(csvFilename));
            for (Object object : csvList) {
                CobasMiraMappingLabitem cmlItem = (CobasMiraMappingLabitem)object;
                cobasMappings.add(cmlItem);
            }
        }
        catch (FileNotFoundException e) {
            Status status = new Status(2, Activator.PLUGIN_ID, "CSV Mapping File nicht gefunden", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
        }
        cobasMappings.remove(0);
    }

    private static ColumnPositionMappingStrategy getMappingStrategy() {
        ColumnPositionMappingStrategy strategy = new ColumnPositionMappingStrategy();
        strategy.setType(CobasMiraMappingLabitem.class);
        String[] columns = new String[]{"testNameCM", "testNameShort", "TestName", "laborwertID", "refM", "refW", "noDecPlaces"};
        strategy.setColumnMapping(columns);
        return strategy;
    }

    public static String getId(String testName) {
        for (CobasMiraMappingLabitem cMMLI : cobasMappings) {
            if (!cMMLI.getTestNameCM().equalsIgnoreCase(testName)) continue;
            return cMMLI.getLaborwertID();
        }
        return null;
    }

    public static int getNoDecPlaces(String testName) {
        for (CobasMiraMappingLabitem cMMLI : cobasMappings) {
            try {
                if (!cMMLI.getTestNameCM().equalsIgnoreCase(testName)) continue;
                return Integer.parseInt(cMMLI.getNoDecPlaces());
            }
            catch (NumberFormatException e) {
                Status status = new Status(2, Activator.PLUGIN_ID, "Error parsing integer string", (Throwable)e);
                StatusManager.getManager().handle((IStatus)status, 2);
            }
        }
        return 0;
    }
}

