/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.model;

import at.medevit.elexis.cobasmira.model.CobasMiraMessage;
import at.medevit.elexis.cobasmira.resulthandler.ErrorMessageHandler;
import at.medevit.elexis.cobasmira.resulthandler.ImportPatientResult;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;

public class CobasMiraLog {
    private static CobasMiraLog instance = null;
    private LinkedList<CobasMiraMessage> messageList = new LinkedList();
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    private CobasMiraLog() {
    }

    public static CobasMiraLog getInstance() {
        if (instance == null) {
            instance = new CobasMiraLog();
        }
        return instance;
    }

    public void addMessage(CobasMiraMessage add) {
        int importSuccess = 0;
        if (add.getBlockType() == CobasMiraMessage.BLOCK_TYPE_PATIENT_RESULTS) {
            importSuccess = ImportPatientResult.importPatientResult(add);
            add.setElexisStatus(importSuccess);
        } else if (add.getBlockType() == CobasMiraMessage.BLOCK_TYPE_ERROR_MESSAGE) {
            add.setElexisStatus(CobasMiraMessage.ELEXIS_RESULT_IGNORED);
            ErrorMessageHandler.handleError(add);
        } else if (add.getBlockType() == CobasMiraMessage.BLOCK_TYPE_RACK_INFORMATION) {
            add.setElexisStatus(CobasMiraMessage.ELEXIS_RESULT_IGNORED);
        }
        this.messageList.add(add);
        this.changes.firePropertyChange("messageList", null, this.messageList);
    }

    public LinkedList<CobasMiraMessage> getMessageList() {
        return this.messageList;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }
}

