/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.connection;

import at.medevit.elexis.cobasmira.model.CobasMiraLog;
import at.medevit.elexis.cobasmira.model.CobasMiraMessage;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobasMiraSerialReader
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CobasMiraSerialReader.class);
    private static final int SOH = 1;
    private static final int STX = 2;
    private static final int ETX = 3;
    private static final int EOT = 4;
    private InputStream in;
    private SerialPort serialPort;
    private boolean keepRunning = true;

    public boolean isKeepRunning() {
        return this.keepRunning;
    }

    public void setKeepRunning(boolean keepRunning) {
        this.keepRunning = keepRunning;
    }

    public CobasMiraSerialReader(InputStream in, SerialPort serialPort) {
        this.serialPort = serialPort;
        this.in = in;
    }

    @Override
    public void run() {
        logger.debug("Starting reader thread");
        try {
            CobasMiraLog cobasMiraLog = CobasMiraLog.getInstance();
            int state = 0;
            StringBuffer headerBuf = new StringBuffer();
            StringBuffer textBuf = new StringBuffer();
            CobasMiraMessage message = null;
            while (this.keepRunning) {
                int data = this.in.read();
                if (data == -1) {
                    try {
                        Thread.sleep(1000L);
                        logger.trace("Waiting for serial input...");
                    }
                    catch (InterruptedException e) {
                        logger.warn("Sleep interrupted", (Throwable)e);
                    }
                    continue;
                }
                if (data == 1) {
                    logger.trace("SOH");
                    headerBuf = new StringBuffer();
                    state = 1;
                    continue;
                }
                if (data == 2) {
                    logger.trace("STX");
                    message = new CobasMiraMessage();
                    message.setHeader(headerBuf.toString());
                    textBuf = new StringBuffer();
                    state = 2;
                    continue;
                }
                if (data == 3) {
                    logger.trace("ETX");
                    if (message != null) {
                        message.setText(textBuf.toString());
                    } else {
                        logger.warn("message is null, programmatic error");
                    }
                    state = 3;
                    continue;
                }
                if (data == 4) {
                    logger.trace("EOT");
                    cobasMiraLog.addMessage(message);
                    state = 4;
                    continue;
                }
                switch (state) {
                    case 1: {
                        headerBuf.append((char)data);
                        break;
                    }
                    case 2: {
                        textBuf.append((char)data);
                        break;
                    }
                    default: {
                        logger.debug("Invalid state! Ignoring " + data);
                    }
                }
            }
            logger.debug("Exiting reader");
            if (this.serialPort != null) {
                this.serialPort.close();
            }
        }
        catch (IOException e) {
            logger.error("Error receveiving data", (Throwable)e);
            e.printStackTrace();
        }
    }
}

