/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.cobasmira.connection;

import at.medevit.elexis.cobasmira.Activator;
import at.medevit.elexis.cobasmira.connection.CobasMiraSerialReader;
import ch.elexis.core.data.activator.CoreHub;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobasMiraConnection
implements PropertyChangeListener {
    private static Logger logger = LoggerFactory.getLogger(CobasMiraConnection.class);
    private static CobasMiraConnection instance = null;
    private Thread cobasMiraReader;
    private CobasMiraSerialReader reader;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private CobasMiraConnection() {
    }

    public static CobasMiraConnection getInstance() {
        if (instance == null) {
            instance = new CobasMiraConnection();
        }
        return instance;
    }

    static void listPorts() {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println(String.valueOf(portIdentifier.getName()) + " - " + CobasMiraConnection.getPortTypeName(portIdentifier.getPortType()));
        }
    }

    static String getPortTypeName(int portType) {
        switch (portType) {
            case 3: {
                return "I2C";
            }
            case 2: {
                return "Parallel";
            }
            case 5: {
                return "Raw";
            }
            case 4: {
                return "RS485";
            }
            case 1: {
                return "Serial";
            }
        }
        return "unknown type";
    }

    void connect(String portName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            logger.warn("Error: Port is currently in use");
        } else {
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = (SerialPort)commPort;
                serialPort.setSerialPortParams(1200, 7, 2, 2);
                serialPort.setFlowControlMode(3);
                serialPort.setDTR(true);
                logger.debug("Opening connection to " + portName);
                logger.debug("BaudRate: " + serialPort.getBaudRate());
                logger.debug("STPB/DTB/PAR: " + serialPort.getStopBits() + " " + serialPort.getDataBits() + " " + serialPort.getParity());
                logger.debug("FCM: " + serialPort.getFlowControlMode() + " should be: " + 3);
                logger.debug("CTS/CD/DTR/DSR/RTS: " + serialPort.isCTS() + " " + serialPort.isCD() + " " + serialPort.isDTR() + " " + serialPort.isDSR() + " " + serialPort.isRTS());
                InputStream in = serialPort.getInputStream();
                this.reader = new CobasMiraSerialReader(in, serialPort);
                this.cobasMiraReader = new Thread(this.reader);
                this.cobasMiraReader.start();
                logger.debug("Reader Thread ID: " + this.cobasMiraReader.getId() + " Priority: " + this.cobasMiraReader.getPriority() + " Name: " + this.cobasMiraReader.getName());
            } else {
                logger.warn("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public boolean isActivated() {
        if (instance == null) {
            return false;
        }
        if (this.cobasMiraReader != null) {
            Thread.State cobasMiraReaderState = this.cobasMiraReader.getState();
            return cobasMiraReaderState != Thread.State.NEW && cobasMiraReaderState != Thread.State.TERMINATED;
        }
        return false;
    }

    public boolean isDeactivated() {
        if (instance == null) {
            return true;
        }
        if (this.cobasMiraReader != null) {
            Thread.State cobasMiraReaderState = this.cobasMiraReader.getState();
            return cobasMiraReaderState == Thread.State.NEW || cobasMiraReaderState == Thread.State.TERMINATED;
        }
        return true;
    }

    public boolean startReadingSerialInput() {
        if (!this.isActivated()) {
            String port = CoreHub.localCfg.get("connectors/cobasmira/port", "/dev/cu.PL2303-0000103D");
            try {
                instance = CobasMiraConnection.getInstance();
                instance.connect(port);
                if (this.isActivated()) {
                    this.propertyChangeSupport.firePropertyChange("status", false, true);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public boolean stopReadingSerialInput() {
        if (this.isActivated()) {
            this.reader.setKeepRunning(false);
            try {
                this.cobasMiraReader.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return !this.isActivated();
        }
        return false;
    }

    public static String[] getComPorts() {
        try {
            Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
            LinkedList<String> portList = new LinkedList<String>();
            while (portEnum.hasMoreElements()) {
                CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
                portList.add(portIdentifier.getName());
            }
            return portList.toArray(new String[portList.size()]);
        }
        catch (UnsatisfiedLinkError e) {
            Status status = new Status(2, Activator.PLUGIN_ID, "Unsatisfied Link", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
            return new String[]{"No ports found"};
        }
        catch (NoClassDefFoundError e) {
            Status status = new Status(2, Activator.PLUGIN_ID, "No class definition found", (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
            return new String[]{"No ports found"};
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getStatus() {
        if (this.isActivated()) {
            return new String("Status: Cobas Mira verbunden auf Port " + CoreHub.localCfg.get("connectors/cobasmira/port", "/dev/cu.PL2303-0000103D") + ", Daten werden gesammelt.");
        }
        return new String("Status: Cobas Mira nicht verbunden.");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

