/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.bluemedication.ui.handler;

import at.medevit.elexis.bluemedication.core.BlueMedicationServiceHolder;
import at.medevit.elexis.bluemedication.core.UploadResult;
import ch.elexis.omnivore.data.DocHandle;
import ch.rgw.tools.Result;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.LoggerFactory;

public class BlueMedicationUploadHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DocHandle docHandle;
        Object object;
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && (object = selection.getFirstElement()) instanceof DocHandle && ((docHandle = (DocHandle)object).getMimeType().toLowerCase().endsWith("pdf") || docHandle.getTitle().toLowerCase().endsWith(".pdf"))) {
            Shell activeshell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(activeshell);
            try {
                progressDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("BlueMedication Upload von " + docHandle.getLabel(), -1);
                        Result result = BlueMedicationServiceHolder.getService().uploadDocument(docHandle.getPatient(), docHandle.createTemporaryFile(docHandle.getTitle()));
                        if (result.isOK()) {
                            Display.getDefault().syncExec(() -> {
                                Program.launch((String)((UploadResult)result.get()).getUrl());
                                BlueMedicationServiceHolder.getService().addPendingUploadResult((Object)docHandle, (UploadResult)result.get());
                            });
                        } else {
                            String resultCode;
                            String text;
                            List messages = result.getMessages();
                            if (messages != null && !messages.isEmpty() && StringUtils.isNotBlank((CharSequence)(text = ((Result.msg)messages.get(0)).getText())) && text.startsWith("Error result code [") && StringUtils.isNotBlank((CharSequence)(resultCode = text.substring(text.indexOf(91) + 1, text.indexOf(93))))) {
                                if ("A6".equals(resultCode)) {
                                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"BlueMedication", (String)"Der Medikationsabgleich kann in BlueMedication nicht durchgef\u00fchrt werden.\nBitte melden Sie den Fehler A6 an help.bluemedication@bluecare.ch"));
                                } else {
                                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"BlueMedication", (String)("Beim Aufruf von BlueMedication ist ein technischer Fehler aufgetreten\nBitte melden Sie den Fehler " + resultCode + " an help.bluemedication@bluecare.ch")));
                                }
                                return;
                            }
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"BlueMedication", (String)"Beim Hochladen der Datei ist ein Fehler aufgetreten.\n\nBitte HIN client Konfiguration pr\u00fcfen."));
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                MessageDialog.openError((Shell)activeshell, (String)"BlueMedication", (String)"Bluemedication Upload konnte nicht gestartet werden.");
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating structured diagnosis", (Throwable)e);
            }
        }
        return null;
    }
}

