/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.bluemedication.ui.handler;

import at.medevit.elexis.bluemedication.core.BlueMedicationServiceHolder;
import at.medevit.elexis.bluemedication.core.UploadResult;
import ch.elexis.omnivore.data.DocHandle;
import ch.rgw.tools.Result;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class BlueMedicationDownloadHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object object;
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && (object = selection.getFirstElement()) instanceof DocHandle) {
            DocHandle docHandle = (DocHandle)object;
            Optional pending = BlueMedicationServiceHolder.getService().getPendingUploadResult((Object)docHandle);
            if (pending.isPresent()) {
                Result emediplan = BlueMedicationServiceHolder.getService().downloadEMediplan((UploadResult)pending.get());
                if (emediplan.isOK()) {
                    if (((UploadResult)pending.get()).isUploadedMediplan()) {
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Import", (String)"M\u00f6chten Sie die aktuelle Medikation mit dem erstellten eMediplan \u00fcberschrieben?")) {
                            ICommandService commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
                            Command directImportCommand = commandService.getCommand("at.medevit.elexis.emediplan.ui.directImport");
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("at.medevit.elexis.emediplan.ui.directImport.parameter.emediplan", (String)emediplan.get());
                            params.put("at.medevit.elexis.emediplan.ui.directImport.parameter.patientid", docHandle.getPatient().getId());
                            params.put("at.medevit.elexis.emediplan.ui.directImport.parameter.stopreason", "BlueMedication EMediplan Import");
                            ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)directImportCommand, params);
                            try {
                                ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                            }
                            catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim import des eMediplan ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
                            }
                        }
                    } else {
                        ICommandService commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
                        Command openImportCommand = commandService.getCommand("at.medevit.elexis.emediplan.ui.openImport");
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("at.medevit.elexis.emediplan.ui.openImport.parameter.emediplan", (String)emediplan.get());
                        params.put("at.medevit.elexis.emediplan.ui.openImport.parameter.patientid", docHandle.getPatient().getId());
                        ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)openImportCommand, params);
                        try {
                            ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                        }
                        catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim \u00f6ffnen des eMediplan Import ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim download ist ein Fehler aufgetreten. Bitte starten sie den Abgleich neu.");
                }
                BlueMedicationServiceHolder.getService().removePendingUploadResult((Object)docHandle);
            }
        }
        return null;
    }
}

