/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.model;

import ch.elexis.agenda.data.IPlannable;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.SerienTermin;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPeriod;

public class Event {
    private static final String DEFAULT_BG_COLOR = "ffffff";
    private String id;
    private String title;
    private String icon;
    private String start;
    private String end;
    private String borderColor;
    private String backgroundColor;
    private String textColor;
    private String rendering;
    private String description;
    private String resource;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    public String getRendering() {
        return this.rendering;
    }

    public void setRendering(String rendering) {
        this.rendering = rendering;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public static Event of(IPeriod iPeriod) {
        Event ret = new Event();
        ret.id = iPeriod.getId();
        ret.start = iPeriod.getStartTime().toLocalDateTime().toString();
        ret.end = iPeriod.getEndTime().toLocalDateTime().toString();
        if (iPeriod instanceof Termin) {
            Termin termin = (Termin)iPeriod;
            ret.resource = termin.getBereich();
            Termin rootTermin = null;
            if (termin.isRecurringDate() && (rootTermin = new SerienTermin((IPlannable)termin).getRootTermin()) != null) {
                ret.icon = "ui-icon-arrowrefresh-1-w";
                ret.title = rootTermin.getPersonalia();
            } else {
                ret.title = termin.getPersonalia();
            }
            if (ret.title.isEmpty()) {
                ret.title = " ";
            }
            ret.description = String.valueOf(termin.getGrund().replaceAll("\n", "<br />")) + "<br /><br />" + termin.getStatusHistoryDesc(true).replaceAll("\n", "<br />");
            ret.borderColor = Event.getStateColor(iPeriod);
            ret.backgroundColor = Event.getTypColor(iPeriod);
            ret.textColor = Event.getTextColor(ret.backgroundColor.substring(1));
        }
        return ret;
    }

    public static boolean isDayLimit(IPeriod iPeriod) {
        if (iPeriod instanceof Termin) {
            String type = ((Termin)iPeriod).getType();
            String status = ((Termin)iPeriod).getStatus();
            return type.equals(Termin.typReserviert()) && status.equals(Termin.statusLeer());
        }
        return false;
    }

    public static String getTypColor(IPeriod iPeriod) {
        if (iPeriod instanceof Termin) {
            Termin termin = (Termin)iPeriod;
            return "#" + CoreHub.userCfg.get("agenda/farben/typ/" + termin.getType(), DEFAULT_BG_COLOR);
        }
        return "#ffffff";
    }

    public static String getStateColor(IPeriod iPeriod) {
        if (iPeriod instanceof Termin) {
            Termin termin = (Termin)iPeriod;
            return "#" + CoreHub.userCfg.get("agenda/farben/status/" + termin.getStatus(), DEFAULT_BG_COLOR);
        }
        return "#ffffff";
    }

    public static String getTextColor(String bgColor) {
        int brightness = Event.getPerceivedBrightness(Integer.parseInt(bgColor.substring(0, 2), 16), Integer.parseInt(bgColor.substring(2, 4), 16), Integer.parseInt(bgColor.substring(4, 6), 16));
        return brightness > 130 ? "#000000" : "#ffffff";
    }

    private static int getPerceivedBrightness(int red, int green, int blue) {
        return (int)Math.sqrt((double)(red * red) * 0.299 + (double)(green * green) * 0.587 + (double)(blue * blue) * 0.114);
    }
}

