/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.function.LoadEventsFunction;
import at.medevit.elexis.agenda.ui.view.AgendaView;
import at.medevit.elexis.agenda.ui.xml.AreaPeriodsLetter;
import ch.elexis.agenda.data.Termin;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class PrintSelectedAgendaHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AgendaView) {
            AgendaView agendaView = (AgendaView)activePart;
            LoadEventsFunction loadEventsFunction = agendaView.getLoadEventsFunction();
            List<IPeriod> periods = loadEventsFunction.getCurrentPeriods();
            Map<String, List<IPeriod>> areaPeriodMap = this.getAreaPeriodMap(periods);
            for (String area : areaPeriodMap.keySet()) {
                File file;
                block16: {
                    BundleContext bundleContext;
                    ServiceReference serviceRef;
                    AreaPeriodsLetter letter = AreaPeriodsLetter.of(area, areaPeriodMap.get(area));
                    if (letter == null || (serviceRef = (bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext()).getServiceReference(IFormattedOutputFactory.class)) == null) continue;
                    IFormattedOutputFactory service = (IFormattedOutputFactory)bundleContext.getService(serviceRef);
                    IFormattedOutput outputter = service.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.JAXB, IFormattedOutputFactory.OutputType.PDF);
                    ByteArrayOutputStream pdf = new ByteArrayOutputStream();
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("current-date", LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
                    outputter.transform((Object)letter, ((Object)((Object)this)).getClass().getResourceAsStream("/rsc/xslt/areaperiods2fo.xslt"), (OutputStream)pdf, parameters);
                    bundleContext.ungetService(serviceRef);
                    file = null;
                    FileOutputStream fout = null;
                    try {
                        try {
                            file = File.createTempFile(String.valueOf(letter.getArea()) + "_", ".pdf");
                            fout = new FileOutputStream(file);
                            fout.write(pdf.toByteArray());
                        }
                        catch (IOException e) {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)("Fehler beim PDF anlegen.\n" + e.getMessage())));
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating PDF", (Throwable)e);
                            if (fout != null) {
                                try {
                                    fout.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (file == null) continue;
                Program.launch((String)file.getAbsolutePath());
            }
        }
        return null;
    }

    private Map<String, List<IPeriod>> getAreaPeriodMap(List<IPeriod> periods) {
        if (periods != null && !periods.isEmpty()) {
            if (periods.get(0) instanceof Termin) {
                HashMap<String, List<IPeriod>> ret = new HashMap<String, List<IPeriod>>();
                for (IPeriod iPeriod : periods) {
                    String area = ((Termin)iPeriod).getBereich();
                    ArrayList<IPeriod> list = (ArrayList<IPeriod>)ret.get(area);
                    if (list == null) {
                        list = new ArrayList<IPeriod>();
                    }
                    list.add(iPeriod);
                    ret.put(area, list);
                }
                return ret;
            }
            throw new IllegalStateException("Can not determine area of period " + periods.get(0));
        }
        return Collections.emptyMap();
    }
}

