/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.handler;

import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.view.AgendaView;
import at.medevit.elexis.agenda.ui.view.ParallelView;
import ch.elexis.core.model.IPeriod;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.LoggerFactory;

public class MoveHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional<IPeriod> period = this.getSelectedPeriod();
        period.ifPresent(p -> {
            IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            SideBarComposite sideBar = null;
            if (activePart instanceof AgendaView) {
                AgendaView view = (AgendaView)activePart;
                sideBar = view.getParallelSideBarComposite();
            } else if (activePart instanceof ParallelView) {
                ParallelView view = (ParallelView)activePart;
                sideBar = view.getSideBarComposite();
            }
            if (sideBar != null) {
                sideBar.addMovePeriod((IPeriod)p);
            }
        });
        return null;
    }

    private Optional<IPeriod> getSelectedPeriod() {
        try {
            Object element;
            ISelection activeSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            if (activeSelection instanceof StructuredSelection && !((StructuredSelection)activeSelection).isEmpty() && (element = ((StructuredSelection)activeSelection).getFirstElement()) instanceof IPeriod) {
                return Optional.of((IPeriod)element);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error setting status", (Throwable)e);
        }
        return Optional.empty();
    }
}

