/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import at.medevit.elexis.agenda.ui.model.Event;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.data.TerminUtil;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.model.IPeriod;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadEventsFunction
extends AbstractBrowserFunction {
    private static Logger logger = LoggerFactory.getLogger(LoadEventsFunction.class);
    private Gson gson;
    private Set<String> resources = new HashSet<String>();
    private ScriptingHelper scriptingHelper;
    private LoadingCache<TimeSpan, EventsJsonValue> cache;
    private long knownLastUpdate = 0L;
    private TimeSpan currentTimeSpan;
    private Heartbeat.HeartListener heartListener;

    public LoadEventsFunction(Browser browser, String name, final ScriptingHelper scriptingHelper) {
        super(browser, name);
        this.gson = new GsonBuilder().create();
        this.scriptingHelper = scriptingHelper;
        this.cache = CacheBuilder.newBuilder().maximumSize(7L).build((CacheLoader)new TimeSpanLoader());
        this.heartListener = new Heartbeat.HeartListener(){

            public void heartbeat() {
                long currentLastUpdate = Termin.getHighestLastUpdate((String)"AGNTERMINE");
                if (LoadEventsFunction.this.knownLastUpdate != 0L && LoadEventsFunction.this.knownLastUpdate < currentLastUpdate) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            scriptingHelper.refetchEvents();
                        }
                    });
                }
            }
        };
        browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CoreHub.heart.removeListener(LoadEventsFunction.this.heartListener);
            }
        });
        CoreHub.heart.addListener(this.heartListener);
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 3) {
            try {
                this.currentTimeSpan = new TimeSpan(this.getDateArg(arguments[0]), this.getDateArg(arguments[1]));
                long currentLastUpdate = Termin.getHighestLastUpdate((String)"AGNTERMINE");
                if (this.knownLastUpdate == 0L) {
                    this.knownLastUpdate = currentLastUpdate;
                } else if (this.knownLastUpdate < currentLastUpdate) {
                    List<IPeriod> changedPeriods = this.getChangedPeriods();
                    ConcurrentMap cacheAsMap = this.cache.asMap();
                    for (TimeSpan timeSpan : cacheAsMap.keySet()) {
                        EventsJsonValue eventsJson = (EventsJsonValue)this.cache.get((Object)timeSpan);
                        if (eventsJson.updateWith(changedPeriods)) {
                            logger.debug("Updated timespan " + timeSpan);
                            continue;
                        }
                        logger.debug("No update to timespan " + timeSpan);
                    }
                    this.knownLastUpdate = currentLastUpdate;
                }
                EventsJsonValue eventsJson = (EventsJsonValue)this.cache.get((Object)this.currentTimeSpan);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!LoadEventsFunction.this.isDisposed()) {
                            LoadEventsFunction.this.updateCalendarHeight();
                            LoadEventsFunction.this.scriptingHelper.scrollToNow();
                        }
                    }
                });
                return eventsJson.getJson();
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Error loading events", e);
            }
        }
        throw new IllegalArgumentException("Unexpected arguments");
    }

    private List<IPeriod> getChangedPeriods() {
        Query query = new Query(Termin.class, "AGNTERMINE", true, null);
        query.clear(true);
        query.add("lastupdate", ">", Long.toString(this.knownLastUpdate));
        return query.execute();
    }

    public void addResource(String resource) {
        this.resources.add(resource);
    }

    public void removeResource(String resource) {
        this.resources.remove(resource);
    }

    public void setResources(List<String> resources) {
        this.resources.clear();
        this.resources.addAll(resources);
        this.cache.invalidateAll();
    }

    public List<IPeriod> getCurrentPeriods() {
        TimeSpanLoader loader = new TimeSpanLoader();
        return loader.getPeriods(this.currentTimeSpan);
    }

    private class EventsJsonValue {
        private Map<String, Event> eventsMap;
        private String jsonString;
        private TimeSpan timespan;

        public EventsJsonValue(TimeSpan key, List<Event> events) {
            this.timespan = key;
            this.eventsMap = events.parallelStream().collect(Collectors.toMap(e -> e.getId(), e -> e));
            this.jsonString = LoadEventsFunction.this.gson.toJson(this.eventsMap.values());
        }

        public String getJson() {
            return this.jsonString;
        }

        public boolean updateWith(List<IPeriod> changedPeriods) {
            boolean updated = false;
            for (IPeriod iPeriod : changedPeriods) {
                if (this.eventsMap.containsKey(iPeriod.getId())) {
                    boolean deleted = ((Termin)iPeriod).isDeleted();
                    if (deleted || !this.timespan.contains(iPeriod)) {
                        this.eventsMap.remove(iPeriod.getId());
                    } else {
                        Event event = Event.of(iPeriod);
                        this.eventsMap.put(event.getId(), event);
                    }
                    updated = true;
                    continue;
                }
                if (!this.timespan.contains(iPeriod)) continue;
                Event event = Event.of(iPeriod);
                this.eventsMap.put(event.getId(), event);
                updated = true;
            }
            if (updated) {
                this.jsonString = LoadEventsFunction.this.gson.toJson(this.eventsMap.values());
            }
            return updated;
        }
    }

    private class TimeSpan {
        private LocalDate startDate;
        private LocalDate endDate;

        public TimeSpan(LocalDate startDate, LocalDate endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
            result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeSpan other = (TimeSpan)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
                return false;
            }
            return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
        }

        private LoadEventsFunction getOuterType() {
            return LoadEventsFunction.this;
        }

        public boolean contains(IPeriod iPeriod) {
            LocalDate periodStartDate = iPeriod.getStartTime().toLocalDate();
            return !(!periodStartDate.isEqual(this.startDate) && !periodStartDate.isAfter(this.startDate) || !periodStartDate.isEqual(this.endDate) && !periodStartDate.isBefore(this.endDate));
        }

        public String toString() {
            return "Timespan [" + this.startDate + " - " + this.endDate + "]";
        }
    }

    private class TimeSpanLoader
    extends CacheLoader<TimeSpan, EventsJsonValue> {
        private TimeSpanLoader() {
        }

        public EventsJsonValue load(TimeSpan key) throws Exception {
            List<IPeriod> periods = this.getPeriods(key);
            return new EventsJsonValue(key, periods.parallelStream().map(p -> Event.of(p)).collect(Collectors.toList()));
        }

        private List<IPeriod> getPeriods(TimeSpan timespan) throws IllegalStateException {
            logger.debug("Loading timespan " + timespan);
            LocalDate from = timespan.startDate;
            LocalDate to = timespan.endDate;
            for (String resource : LoadEventsFunction.this.resources) {
                LocalDate updateDate = LocalDate.from(from);
                do {
                    TerminUtil.updateBoundaries((String)resource, (TimeTool)new TimeTool(updateDate));
                } while ((updateDate = updateDate.plusDays(1L)).isBefore(to) || updateDate.isEqual(to));
            }
            ArrayList<IPeriod> ret = new ArrayList<IPeriod>();
            Query query = new Query(Termin.class, null, null, "AGNTERMINE", new String[]{"BeiWem", "Beginn", "Tag", "Dauer", "Status", "Typ", "linkgroup", "Wer", "Grund", "StatusHistory"});
            if (!LoadEventsFunction.this.resources.isEmpty()) {
                String[] resourceArray = LoadEventsFunction.this.resources.toArray(new String[LoadEventsFunction.this.resources.size()]);
                query.startGroup();
                int i = 0;
                while (i < resourceArray.length) {
                    if (i > 0) {
                        query.or();
                    }
                    query.add("BeiWem", "=", resourceArray[i]);
                    ++i;
                }
                query.endGroup();
                query.and();
                query.startGroup();
                if (from != null) {
                    TimeTool time = new TimeTool(from);
                    query.add("Tag", ">=", time.toString(9));
                }
                if (to != null) {
                    TimeTool time = new TimeTool(to);
                    query.add("Tag", "<=", time.toString(9));
                }
                query.endGroup();
                List iPeriods = query.execute();
                ret.addAll(iPeriods);
            }
            logger.debug("Loading timespan " + timespan + " finished");
            return ret;
        }
    }
}

