/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.dialogs.TerminDialog;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Shell;

public class DayClickFunction
extends AbstractBrowserFunction {
    private List<String> selectedResources;

    public DayClickFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 1) {
            LocalDateTime date = this.getDateTimeArg(arguments[0]);
            if (this.selectedResources != null && !this.selectedResources.isEmpty()) {
                TerminDialog dlg = new TerminDialog(new TimeTool(date), this.selectedResources.get(0), ElexisEventDispatcher.getSelectedPatient());
                dlg.setCollisionErrorLevel(TerminDialog.CollisionErrorLevel.WARNING);
                dlg.open();
            } else {
                MessageDialog.openInformation((Shell)this.getBrowser().getShell(), (String)"Info", (String)"Keine Resource selektiert.");
            }
        } else if (arguments.length == 2) {
            LocalDateTime date = this.getDateTimeArg(arguments[0]);
            String resource = (String)arguments[1];
            TerminDialog dlg = new TerminDialog(new TimeTool(date), resource, ElexisEventDispatcher.getSelectedPatient());
            dlg.setCollisionErrorLevel(TerminDialog.CollisionErrorLevel.WARNING);
            dlg.open();
        }
        return null;
    }

    public void setSelectedResources(List<String> selectedResources) {
        this.selectedResources = selectedResources;
    }
}

