/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.function;

import at.medevit.elexis.agenda.ui.composite.SideBarComposite;
import at.medevit.elexis.agenda.ui.function.AbstractBrowserFunction;
import ch.elexis.agenda.data.Termin;
import java.time.LocalDateTime;
import java.util.Optional;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Display;

public class ContextMenuFunction
extends AbstractBrowserFunction {
    private ISelectionProvider selectionProvider;

    public ContextMenuFunction(Browser browser, String name) {
        super(browser, name);
    }

    public Object function(Object[] arguments) {
        if (arguments.length == 2) {
            LocalDateTime date = this.getDateTimeArg(arguments[0]);
            String resource = (String)arguments[1];
            Optional<SideBarComposite> activeSideBar = ContextMenuFunction.getActiveSideBar();
            activeSideBar.ifPresent(sideBar -> {
                sideBar.setMoveInformation(date, resource);
                this.getBrowser().getMenu().setVisible(true);
            });
        } else if (arguments.length == 1) {
            Termin termin = Termin.load((String)((String)arguments[0]));
            if (this.selectionProvider != null) {
                this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)termin));
            }
            Display.getDefault().asyncExec(() -> this.getBrowser().getMenu().setVisible(false));
            Display.getDefault().asyncExec(() -> this.getBrowser().getMenu().setVisible(true));
        } else if (arguments.length == 0 && this.selectionProvider != null) {
            this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        return null;
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }
}

