/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import at.medevit.elexis.agenda.ui.composite.ScriptingHelper;
import at.medevit.elexis.agenda.ui.function.ContextMenuFunction;
import at.medevit.elexis.agenda.ui.function.DayClickFunction;
import at.medevit.elexis.agenda.ui.function.DoubleClickFunction;
import at.medevit.elexis.agenda.ui.function.EventDropFunction;
import at.medevit.elexis.agenda.ui.function.EventResizeFunction;
import at.medevit.elexis.agenda.ui.function.LoadEventsFunction;
import at.medevit.elexis.agenda.ui.function.SingleClickFunction;
import at.medevit.elexis.agenda.ui.function.SwitchFunction;
import ch.elexis.core.data.activator.CoreHub;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDate;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;

public class WeekComposite
extends Composite
implements ISelectionProvider,
IAgendaComposite {
    private Browser browser;
    private LoadEventsFunction loadEventsFunction;
    private ScriptingHelper scriptingHelper;
    private ISelection currentSelection;
    private ListenerList listeners = new ListenerList();
    private IAgendaComposite.AgendaSpanSize currentSpanSize;
    private DayClickFunction dayClickFunction;

    public WeekComposite(IWorkbenchPartSite partSite, Composite parent, int style) {
        this(partSite, parent, style, false);
    }

    public WeekComposite(IWorkbenchPartSite partSite, Composite parent, int style, boolean enableSwitch) {
        super(parent, style);
        URL url;
        this.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, 0);
        this.scriptingHelper = new ScriptingHelper(this.browser);
        this.loadEventsFunction = new LoadEventsFunction(this.browser, "loadEventsFunction", this.scriptingHelper);
        new SingleClickFunction(this.browser, "singleClickFunction").setSelectionProvider(this);
        new DoubleClickFunction(this.browser, "doubleClickFunction");
        new ContextMenuFunction(this.browser, "contextMenuFunction").setSelectionProvider(this);
        new EventDropFunction(this.browser, "eventDropFunction");
        new EventResizeFunction(this.browser, "eventResizeFunction");
        this.dayClickFunction = new DayClickFunction(this.browser, "dayClickFunction");
        if (enableSwitch) {
            new SwitchFunction(this.browser, "switchFunction");
            try {
                url = FileLocator.toFileURL((URL)FrameworkUtil.getBundle(this.getClass()).getResource("/rsc/html/switchWeek.html"));
                LoggerFactory.getLogger(this.getClass()).debug("Open url [" + url.getFile() + "]");
                this.browser.setUrl(url.toString());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not set url to /rsc/html/switchWeek.html", (Throwable)e);
            }
        } else {
            try {
                url = FileLocator.toFileURL((URL)FrameworkUtil.getBundle(this.getClass()).getResource("/rsc/html/defaultWeek.html"));
                LoggerFactory.getLogger(this.getClass()).debug("Open url [" + url.getFile() + "]");
                this.browser.setUrl(url.toString());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not set url to /rsc/html/defaultWeek.html", (Throwable)e);
            }
        }
        this.browser.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                WeekComposite.this.loadEventsFunction.updateCalendarHeight();
            }
        });
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.browser);
        this.browser.setMenu(menu);
        if (partSite != null) {
            partSite.setSelectionProvider((ISelectionProvider)this);
            partSite.registerContextMenu("at.medevit.elexis.agenda.ui.week", menuManager, (ISelectionProvider)this);
        }
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void changed(ProgressEvent event) {
                if (event.current == 0 && event.total == 0) {
                    String dayStartsAt = CoreHub.globalCfg.get("agenda/beginnStundeTagesdarstellung", "0000");
                    String dayEndsAt = CoreHub.globalCfg.get("agenda/endStundeTagesdarstellung", "2359");
                    WeekComposite.this.scriptingHelper.setCalenderTime(dayStartsAt, dayEndsAt);
                    if (WeekComposite.this.currentSpanSize != null) {
                        WeekComposite.this.setSelectedSpanSize(WeekComposite.this.currentSpanSize);
                    }
                    WeekComposite.this.getConfiguredFontSize().ifPresent(size -> {
                        WeekComposite.this.setFontSize((int)size);
                        WeekComposite.this.getConfiguredFontFamily().ifPresent(family -> WeekComposite.this.setFontFamily((String)family));
                    });
                }
            }
        });
    }

    public boolean setFocus() {
        this.refetchEvents();
        return this.browser.setFocus();
    }

    @Override
    public void refetchEvents() {
        this.scriptingHelper.refetchEvents();
    }

    @Override
    public void setSelectedDate(LocalDate date) {
        this.scriptingHelper.setSelectedDate(date);
    }

    @Override
    public void setFontSize(int sizePx) {
        this.scriptingHelper.setFontSize(sizePx);
    }

    @Override
    public void setFontFamily(String family) {
        this.scriptingHelper.setFontFamily(family);
    }

    @Override
    public void setSelectedSpanSize(IAgendaComposite.AgendaSpanSize size) {
        this.currentSpanSize = size;
        this.scriptingHelper.setSelectedSpanSize(size);
    }

    @Override
    public void setSelectedResources(List<String> selectedResources) {
        this.loadEventsFunction.setResources(selectedResources);
        this.dayClickFunction.setSelectedResources(selectedResources);
        this.refetchEvents();
    }

    @Override
    public String getConfigId() {
        return "week";
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.currentSelection != null) {
            return this.currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.currentSelection = selection;
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            ++n2;
        }
    }

    @Override
    public void setScrollToNow(boolean value) {
        this.scriptingHelper.setScrollToNow(value);
    }

    public LoadEventsFunction getLoadEventsFunction() {
        return this.loadEventsFunction;
    }
}

