/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import ch.elexis.agenda.data.Termin;
import ch.elexis.agenda.series.ui.SerienTerminDialog;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPeriod;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class SideBarComposite
extends Composite {
    private IAgendaComposite agendaComposite;
    private List<String> selectedResources = new ArrayList<String>();
    private ComboViewer spanSizeCombo;
    private ToolBarManager menuManager;
    private Button scrollToNowCheck;
    private TableViewer moveTable;
    private List<IPeriod> movePeriods;
    private MoveInformation currentMoveInformation;

    public SideBarComposite(Composite parent, int style) {
        this(parent, false, style);
    }

    public SideBarComposite(Composite parent, boolean includeMove, int style) {
        super(parent, style);
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.setBackgroundMode(2);
        this.setLayout((Layout)new GridLayout(1, true));
        this.menuManager = new ToolBarManager(0x800100);
        this.menuManager.add((IAction)new Action(">", 1){

            public void run() {
                if (">".equals(super.getText())) {
                    SideBarComposite.this.showContent();
                    super.setText("<");
                } else {
                    SideBarComposite.this.hideContent();
                    super.setText(">");
                }
                super.run();
            }
        });
        this.menuManager.createControl((Composite)this).setLayoutData((Object)new GridData(131072, 128, false, false));
        final DateTime calendar = new DateTime((Composite)this, 1024);
        calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SideBarComposite.this.agendaComposite.setSelectedDate(LocalDate.of(calendar.getYear(), calendar.getMonth() + 1, calendar.getDay()));
            }
        });
        Label label = new Label((Composite)this, 0);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        label.setFont(boldFont);
        label.setText("Bereiche");
        String[] stringArray = Termin.TerminBereiche;
        int n = Termin.TerminBereiche.length;
        int n2 = 0;
        while (n2 < n) {
            String bereich = stringArray[n2];
            Button btn = new Button((Composite)this, 32);
            btn.setText(bereich);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.getSource() instanceof Button) {
                        if (((Button)e.getSource()).getSelection()) {
                            SideBarComposite.this.selectedResources.add(((Button)e.getSource()).getText());
                        } else {
                            SideBarComposite.this.selectedResources.remove(((Button)e.getSource()).getText());
                        }
                        SideBarComposite.this.agendaComposite.setSelectedResources(SideBarComposite.this.selectedResources);
                        SideBarComposite.this.saveSelectedResources();
                    }
                }
            });
            ++n2;
        }
        label = new Label((Composite)this, 0);
        label.setFont(boldFont);
        label.setText("Zeitschritte");
        this.spanSizeCombo = new ComboViewer((Composite)this, 2048);
        this.spanSizeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.spanSizeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IAgendaComposite.AgendaSpanSize)((Object)element)).getLabel();
            }
        });
        this.spanSizeCombo.setInput((Object)IAgendaComposite.AgendaSpanSize.values());
        this.spanSizeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    SideBarComposite.this.agendaComposite.setSelectedSpanSize((IAgendaComposite.AgendaSpanSize)((Object)((StructuredSelection)selection).getFirstElement()));
                    SideBarComposite.this.saveConfigurationString("selectedSpanSize", ((IAgendaComposite.AgendaSpanSize)((Object)((StructuredSelection)selection).getFirstElement())).name());
                }
            }
        });
        label = new Label((Composite)this, 0);
        label.setFont(boldFont);
        label.setText("Auto. zu jetzt scrollen");
        this.scrollToNowCheck = new Button((Composite)this, 32);
        this.scrollToNowCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SideBarComposite.this.agendaComposite.setScrollToNow(SideBarComposite.this.scrollToNowCheck.getSelection());
                SideBarComposite.this.saveConfigurationString("scrollToNow", Boolean.toString(SideBarComposite.this.scrollToNowCheck.getSelection()));
                super.widgetSelected(e);
            }
        });
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(768));
        Button btn = new Button((Composite)this, 0);
        btn.setText("Neue Serie anlegen");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    SerienTerminDialog dlg = new SerienTerminDialog(SideBarComposite.this.getShell(), null);
                    dlg.open();
                }
            }
        });
        if (includeMove) {
            label = new Label((Composite)this, 0);
            label.setFont(boldFont);
            label.setText("Termin verschieben");
            label.setLayoutData((Object)new GridData(4, 1024, true, true));
            this.moveTable = new TableViewer((Composite)this, 2);
            this.moveTable.getTable().setLayoutData((Object)new GridData(4, 1024, true, false));
            this.moveTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.moveTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IPeriod) {
                        return ((IPeriod)element).getLabel();
                    }
                    return super.getText(element);
                }
            });
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(){

                public String getText() {
                    return "verschieben abbrechen";
                }

                public ImageDescriptor getImageDescriptor() {
                    return Images.IMG_DELETE.getImageDescriptor();
                }

                public void run() {
                    IStructuredSelection selection = SideBarComposite.this.moveTable.getStructuredSelection();
                    if (selection != null && !selection.isEmpty()) {
                        for (Object selected : selection.toList()) {
                            if (!(selected instanceof IPeriod)) continue;
                            SideBarComposite.this.removeMovePeriod((IPeriod)selected);
                        }
                    }
                }
            });
            Menu contextMenu = menuManager.createContextMenu((Control)this.moveTable.getTable());
            this.moveTable.getTable().setMenu(contextMenu);
            GridData gd = new GridData(16384, 1024, false, false);
            gd.widthHint = 150;
            this.moveTable.getTable().setLayoutData((Object)gd);
            this.movePeriods = new ArrayList<IPeriod>();
        }
        this.hideContent();
    }

    private void hideContent() {
        Control[] controls;
        Control[] controlArray = controls = this.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!(control instanceof ToolBar)) {
                GridData gridData = (GridData)control.getLayoutData();
                if (gridData == null) {
                    gridData = new GridData();
                    control.setLayoutData((Object)gridData);
                }
                control.setVisible(false);
                gridData.exclude = true;
            }
            ++n2;
        }
        this.getParent().layout();
    }

    private void showContent() {
        Control[] controls;
        Control[] controlArray = controls = this.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            GridData gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData();
                control.setLayoutData((Object)gridData);
            }
            control.setVisible(true);
            gridData.exclude = false;
            ++n2;
        }
        this.getParent().layout();
    }

    public void setAgendaComposite(IAgendaComposite agendaComposite) {
        String value;
        this.agendaComposite = agendaComposite;
        this.loadSelectedResources();
        agendaComposite.setSelectedResources(this.selectedResources);
        String selectedSpanSize = this.loadConfigurationString("selectedSpanSize");
        if (!selectedSpanSize.isEmpty()) {
            this.spanSizeCombo.setSelection((ISelection)new StructuredSelection((Object)IAgendaComposite.AgendaSpanSize.valueOf(selectedSpanSize)));
        }
        if ((value = this.loadConfigurationString("scrollToNow")) != null && value.equalsIgnoreCase("true")) {
            this.scrollToNowCheck.setSelection(true);
            agendaComposite.setScrollToNow(true);
        }
    }

    private void saveSelectedResources() {
        this.agendaComposite.setSelectedResources(this.selectedResources);
        StringBuilder sb = new StringBuilder();
        for (String resource : this.selectedResources) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(resource);
        }
        this.saveConfigurationString("selectedResources", sb.toString());
    }

    private void loadSelectedResources() {
        String loadedResources = this.loadConfigurationString("selectedResources");
        String[] parts = loadedResources.split("\\|");
        if (parts.length > 0 && !parts[0].isEmpty()) {
            this.selectedResources.clear();
            this.selectedResources.addAll(Arrays.asList(parts));
            ArrayList<String> selections = new ArrayList<String>();
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Button) {
                    if (this.selectedResources.contains(((Button)child).getText())) {
                        ((Button)child).setSelection(true);
                        selections.add(((Button)child).getText());
                    } else {
                        ((Button)child).setSelection(false);
                    }
                }
                ++n2;
            }
            this.selectedResources = selections;
        }
    }

    private void saveConfigurationString(String configKey, String value) {
        CoreHub.localCfg.set("at.medevit.elexis.agenda.ui/" + this.agendaComposite.getConfigId() + "/" + configKey, value);
    }

    private String loadConfigurationString(String configKey) {
        return CoreHub.localCfg.get("at.medevit.elexis.agenda.ui/" + this.agendaComposite.getConfigId() + "/" + configKey, "");
    }

    public void addMovePeriod(IPeriod period) {
        if (this.moveTable != null && !this.moveTable.getTable().isDisposed()) {
            if (!this.movePeriods.contains(period)) {
                this.movePeriods.add(period);
            }
            this.moveTable.setInput(this.movePeriods);
        }
    }

    public void removeMovePeriod(IPeriod period) {
        if (this.moveTable != null && !this.moveTable.getTable().isDisposed()) {
            this.movePeriods.remove(period);
            this.moveTable.setInput(this.movePeriods);
        }
    }

    public Optional<MoveInformation> getMoveInformation() {
        if (this.currentMoveInformation != null) {
            this.currentMoveInformation.setMoveablePeriods(this.movePeriods);
        }
        return Optional.ofNullable(this.currentMoveInformation);
    }

    public void setMoveInformation(LocalDateTime date, String resource) {
        this.currentMoveInformation = new MoveInformation(this, date, resource);
    }

    public static class MoveInformation {
        private SideBarComposite sideBar;
        private LocalDateTime dateTime;
        private String resource;
        private List<IPeriod> moveablePeriods;

        public MoveInformation(SideBarComposite sideBar, LocalDateTime dateTime, String resource) {
            this.sideBar = sideBar;
            this.dateTime = dateTime;
            this.resource = resource;
        }

        public void setMoveablePeriods(List<IPeriod> periods) {
            this.moveablePeriods = new ArrayList<IPeriod>(periods);
        }

        public List<IPeriod> getMoveablePeriods() {
            return this.moveablePeriods;
        }

        public void movePeriod(final IPeriod iPeriod) {
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)((IPersistentObject)iPeriod), (ILockHandler)new ILockHandler(){

                public void lockAcquired() {
                    iPeriod.setStartTime(new TimeTool(dateTime));
                    if (iPeriod instanceof Termin) {
                        ((Termin)iPeriod).setBereich(resource);
                    }
                    Display.getDefault().timerExec(250, new Runnable(){

                        @Override
                        public void run() {
                            if (sideBar != null && !sideBar.isDisposed()) {
                                sideBar.removeMovePeriod(iPeriod);
                                sideBar.agendaComposite.refetchEvents();
                            }
                        }
                    });
                }

                public void lockFailed() {
                }
            });
        }
    }
}

