/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.agenda.ui.composite;

import at.medevit.elexis.agenda.ui.composite.IAgendaComposite;
import java.time.LocalDate;
import java.util.List;
import org.eclipse.swt.browser.Browser;

public class ScriptingHelper {
    private Browser browser;
    private volatile boolean doScroll;

    public ScriptingHelper(Browser browser) {
        this.browser = browser;
    }

    public void setSelectedSpanSize(IAgendaComposite.AgendaSpanSize size) {
        String slotDuration = "$('#calendar').fullCalendar('option', 'slotDuration', '%s');";
        String script = String.format(slotDuration, size.getCalendarString());
        this.browser.execute(script);
        this.scrollToNow();
    }

    private String parseTime(String time) {
        if (time.length() < 6 || time.lastIndexOf(":") != 5) {
            StringBuilder builder = new StringBuilder(6);
            time = time.replaceAll(":", "");
            int length = time.length();
            int i = 0;
            while (i < 6) {
                if (i > 0 && i % 2 == 0) {
                    builder.append(":");
                }
                if (i < length) {
                    char c = time.charAt(i);
                    builder.append(c);
                } else {
                    builder.append("0");
                }
                ++i;
            }
            return builder.toString();
        }
        return time;
    }

    public void setCalenderTime(String dayStartsAt, String dayEndsAt) {
        String endsAt = "$('#calendar').fullCalendar('option', 'maxTime', '%s');";
        String startAt = "$('#calendar').fullCalendar('option', 'minTime', '%s');";
        String script = String.valueOf(String.format(endsAt, this.parseTime(dayEndsAt))) + String.format(startAt, this.parseTime(dayStartsAt));
        this.browser.execute(script);
        this.scrollToNow();
    }

    public void setSelectedDate(LocalDate date) {
        String gotoDate = "$('#calendar').fullCalendar('gotoDate', '%s');";
        String script = String.format(gotoDate, date.toString());
        this.browser.execute(script);
    }

    public void setFontSize(int sizePx) {
        String bodyFontSize = "$('body').css('font-size', '%dpx');";
        String script = String.format(bodyFontSize, sizePx);
        this.browser.execute(script);
    }

    public void setFontFamily(String family) {
        String bodyFontFamily = "$('body').css('font-family', '%s');";
        String script = String.format(bodyFontFamily, family);
        this.browser.execute(script);
    }

    public void refetchEvents() {
        String refetchEvents = "$('#calendar').fullCalendar('refetchEvents');";
        this.browser.execute(refetchEvents);
    }

    public void initializeResources(List<String> selectedResources) {
        String updateResourceIds = "$('#calendar').fullCalendar('getView').setResourceIds(%s);";
        String script = String.format(updateResourceIds, this.getResourceIdsString(selectedResources));
        this.browser.execute(script);
    }

    public void scrollToNow() {
        if (this.doScroll) {
            String script = "var now = $('#calendar').fullCalendar('getNow'); if (now >= $('#calendar').fullCalendar('getView').intervalStart && now < $('#calendar').fullCalendar('getView').intervalEnd){ setTimeout( function(){$('.fc-scroller').scrollTop($('.fc-now-indicator').position().top - ($('#calendar').height() / 2) );}  , 500 );}";
            this.browser.execute(script);
        }
    }

    private Object getResourceIdsString(List<String> selectedResources) {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        for (String calendar : selectedResources) {
            if (ret.length() > 1) {
                ret.append(",");
            }
            ret.append("'").append(calendar).append("'");
        }
        ret.append("]");
        return ret;
    }

    public void setScrollToNow(boolean value) {
        this.doScroll = value;
        this.scrollToNow();
    }
}

