/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm;

public enum BlackBoxReason {
    NOT_BLACKBOXED(0),
    IS_ON_STOCK(1),
    IS_REFERENCED_IN_FIXMEDICATION(2),
    IS_REFERENCED_IN_CONSULTATION(3),
    INACTIVE(9);

    private int numercialReason;

    private BlackBoxReason(int numercialReason) {
        this.numercialReason = numercialReason;
    }

    public int getNumercialReason() {
        return this.numercialReason;
    }

    public String getNumericalReasonString() {
        return String.valueOf(this.numercialReason);
    }

    public String getReasonExplanationString() {
        switch (this.numercialReason) {
            case 0: {
                return "";
            }
            case 1: {
                return "Artikel wird auf Lager gef\u00fchrt";
            }
            case 2: {
                return "Artikel ist als Fixmedikation gef\u00fchrt";
            }
            case 3: {
                return "Artikel ist in einer Konsultation verschrieben";
            }
            case 9: {
                return "Artikel ist inaktiv";
            }
        }
        return "Invalid value";
    }

    public static BlackBoxReason getByInteger(int reason) {
        switch (reason) {
            case 0: {
                return NOT_BLACKBOXED;
            }
            case 1: {
                return IS_ON_STOCK;
            }
            case 2: {
                return IS_REFERENCED_IN_FIXMEDICATION;
            }
            case 3: {
                return IS_REFERENCED_IN_CONSULTATION;
            }
            case 9: {
                return INACTIVE;
            }
        }
        return null;
    }
}

