/*
 * Decompiled with CFR 0.152.
 */
package ch.artikelstamm.elexis.common;

import at.medevit.ch.artikelstamm.ArtikelstammConstants;
import at.medevit.ch.artikelstamm.ArtikelstammHelper;
import at.medevit.ch.artikelstamm.BlackBoxReason;
import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.preference.MargePreference;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.ui.optifier.NoObligationOptifier;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ArtikelstammItem
extends Artikel
implements IArtikelstammItem {
    private static DateFormat df = new SimpleDateFormat("ddMMyy HH:mm");
    private static IOptifier noObligationOptifier = new NoObligationOptifier();
    private static IOptifier defaultOptifier = new IVerrechenbar.DefaultOptifier();
    private final double ZERO = 0.0;
    public static final String TABLENAME = "ARTIKELSTAMM_CH";
    private static final String VERSION_ENTRY_ID = "VERSION";
    static final String VERSION = "1.3.0";
    private static int IS_USER_DEFINED_PKG_SIZE = -999999;
    public static final String FLD_CUMMULATED_VERSION = "CUMM_VERSION";
    public static final String FLD_BLACKBOXED = "BB";
    public static final String FLD_ITEM_TYPE = "TYPE";
    public static final String FLD_GTIN = "GTIN";
    public static final String FLD_PHAR = "PHAR";
    public static final String FLD_DSCR = "DSCR";
    public static final String FLD_ADDDSCR = "ADDDSCR";
    public static final String FLD_ATC = "ATC";
    public static final String FLD_COMP_GLN = "COMP_GLN";
    public static final String FLD_COMP_NAME = "COMP_NAME";
    public static final String FLD_PEXF = "PEXF";
    public static final String FLD_PPUB = "PPUB";
    public static final String FLD_PKG_SIZE = "PKG_SIZE";
    public static final String FLD_SL_ENTRY = "SL_ENTRY";
    public static final String FLD_IKSCAT = "IKSCAT";
    public static final String FLD_LIMITATION = "LIMITATION";
    public static final String FLD_LIMITATION_PTS = "LIMITIATION_PTS";
    public static final String FLD_LIMITATION_TEXT = "LIMITATION_TXT";
    public static final String FLD_GENERIC_TYPE = "GENERIC_TYPE";
    public static final String FLD_HAS_GENERIC = "HAS_GENERIC";
    public static final String FLD_LPPV = "LPPV";
    public static final String FLD_DEDUCTIBLE = "DEDUCTIBLE";
    public static final String FLD_NARCOTIC = "NARCOTIC";
    public static final String FLD_NARCOTIC_CAS = "NARCOTIC_CAS";
    public static final String FLD_VACCINE = "VACCINE";
    public static final String FLD_PRODNO = "PRODNO";
    public static final String EXTINFO_VAL_VAT_OVERRIDEN = "VAT_OVERRIDE";
    public static final String EXTINFO_VAL_PPUB_OVERRIDE_STORE = "PPUB_OVERRIDE_STORE";
    public static final String EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE = "PKG_SIZE_OVERRIDE_STORE";
    static final String createDB = "CREATE TABLE ARTIKELSTAMM_CH(ID VARCHAR(25) primary key,lastupdate BIGINT,deleted CHAR(1) default '0',TYPE CHAR(1),BB CHAR(1),CUMM_VERSION CHAR(4),GTIN VARCHAR(14),PHAR CHAR(7),DSCR VARCHAR(100),ADDDSCR VARCHAR(50),ATC CHAR(10),COMP_GLN CHAR(13),COMP_NAME VARCHAR(255),PEXF CHAR(10),PPUB CHAR(10),PKG_SIZE CHAR(6),SL_ENTRY CHAR(1),IKSCAT CHAR(1),LIMITATION CHAR(1),LIMITIATION_PTS CHAR(4),LIMITATION_TXT TEXT,GENERIC_TYPE CHAR(1),HAS_GENERIC CHAR(1),LPPV CHAR(1),DEDUCTIBLE CHAR(6),NARCOTIC CHAR(1),NARCOTIC_CAS VARCHAR(20),VACCINE CHAR(1),Verkaufseinheit VARCHAR(4),PRODNO VARCHAR(10),ExtInfo BLOB); CREATE INDEX idxAiPHAR ON ARTIKELSTAMM_CH (PHAR); CREATE INDEX idxAiITEMTYPE ON ARTIKELSTAMM_CH (TYPE); CREATE INDEX idxAiGTIN ON ARTIKELSTAMM_CH (GTIN); CREATE INDEX idxAiMONTH ON ARTIKELSTAMM_CH (CUMM_VERSION); CREATE INDEX idxAiBB ON ARTIKELSTAMM_CH (BB); INSERT INTO ARTIKELSTAMM_CH (ID,GTIN,NARCOTIC_CAS,PEXF,PPUB) VALUES ('VERSION'," + JdbcLink.wrap((String)"1.3.0") + "," + JdbcLink.wrap((String)df.format(new Date())) + ",0,0);";
    static final String dbUpdateFrom10to11 = "ALTER TABLE ARTIKELSTAMM_CH ADD ExtInfo BLOB;";
    static final String dbUpdateFrom11to12 = "ALTER TABLE ARTIKELSTAMM_CH ADD PRODNO VARCHAR(10);";
    static final String dbUpdateFrom12to13 = "ALTER TABLE ARTIKELSTAMM_CH MODIFY DSCR VARCHAR(100);";

    static {
        ArtikelstammItem.addMapping((String)TABLENAME, (String[])new String[]{FLD_ITEM_TYPE, "Typ=TYPE", FLD_CUMMULATED_VERSION, FLD_BLACKBOXED, FLD_GTIN, FLD_PHAR, "Pharmacode=PHAR", FLD_DSCR, FLD_ADDDSCR, FLD_ATC, FLD_COMP_GLN, FLD_COMP_NAME, FLD_PEXF, "EK_Preis=PEXF", FLD_PPUB, "VK_Preis=PPUB", FLD_PKG_SIZE, FLD_SL_ENTRY, FLD_IKSCAT, FLD_LIMITATION, FLD_LIMITATION_PTS, FLD_LIMITATION_TEXT, FLD_GENERIC_TYPE, FLD_HAS_GENERIC, FLD_LPPV, FLD_DEDUCTIBLE, FLD_NARCOTIC, FLD_NARCOTIC_CAS, FLD_VACCINE, "Verkaufseinheit", FLD_PRODNO, "ExtInfo"});
        ArtikelstammItem version = ArtikelstammItem.load(VERSION_ENTRY_ID);
        if (!version.exists()) {
            ArtikelstammItem.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_GTIN));
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder("1.1.0")) {
                    ArtikelstammItem.createOrModifyTable((String)dbUpdateFrom10to11);
                    version.set(FLD_GTIN, "1.1.0");
                }
                if (vi.isOlder("1.2.0")) {
                    ArtikelstammItem.createOrModifyTable((String)dbUpdateFrom11to12);
                    version.set(FLD_GTIN, VERSION);
                }
                if (vi.isOlder(VERSION)) {
                    ArtikelstammItem.createOrModifyTable((String)dbUpdateFrom12to13);
                    version.set(FLD_GTIN, VERSION);
                }
            }
        }
    }

    public String getLabel() {
        String[] vals = this.get(true, new String[]{FLD_DSCR, FLD_ADDDSCR});
        return vals[1].length() > 0 ? String.valueOf(vals[0]) + " (" + vals[1] + ")" : vals[0];
    }

    protected String getTableName() {
        return TABLENAME;
    }

    ArtikelstammItem() {
    }

    public static ArtikelstammItem load(String id) {
        return new ArtikelstammItem(id);
    }

    protected ArtikelstammItem(String id) {
        super(id);
    }

    public ArtikelstammItem(int version, ArtikelstammConstants.TYPE type, String gtin, BigInteger code, String dscr, String addscr) {
        if (dscr.length() > 100) {
            dscr = dscr.substring(0, 100);
            log.warn("Delimiting dscr to 100 chars for [{}] info [{}]", (Object)dscr, (Object)(type + "/" + version + "/" + code));
        }
        if (ArtikelstammConstants.TYPE.X == type) {
            this.create(gtin);
            this.set(new String[]{FLD_ITEM_TYPE, FLD_DSCR, FLD_CUMMULATED_VERSION, FLD_BLACKBOXED}, new String[]{type.name(), dscr, Integer.toString(version), "0"});
        } else {
            code = code != null ? code : BigInteger.ZERO;
            String pharmaCode = String.format("%07d", code);
            this.create(ArtikelstammHelper.createUUID((int)version, (String)gtin, (BigInteger)code));
            this.set(new String[]{FLD_ITEM_TYPE, FLD_GTIN, FLD_PHAR, FLD_DSCR, FLD_ADDDSCR, FLD_CUMMULATED_VERSION, FLD_BLACKBOXED}, new String[]{type.name(), gtin, pharmaCode, dscr, addscr, Integer.toString(version), "0"});
        }
    }

    public static ArtikelstammItem loadByPHARNo(String pharNo) {
        Query qbe = new Query(ArtikelstammItem.class);
        String res = qbe.findSingle(FLD_PHAR, "=", pharNo);
        if (res == null) {
            return null;
        }
        return ArtikelstammItem.load(res);
    }

    public String getName() {
        return ArtikelstammItem.checkNull((Object)this.get(FLD_DSCR));
    }

    public boolean isProduct() {
        return ArtikelstammConstants.TYPE.X == this.getType();
    }

    public int getPackungsGroesse() {
        int val = 0;
        try {
            val = Integer.parseInt(this.get(FLD_PKG_SIZE));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public int getAbgabeEinheit() {
        int val = 0;
        try {
            val = Integer.parseInt(this.get("Verkaufseinheit"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public String getPackungsGroesseDesc() {
        return ArtikelstammItem.checkNull((Object)this.get(FLD_ADDDSCR));
    }

    public Money getKosten(TimeTool dat) {
        double vkt = ArtikelstammItem.checkZeroDouble((String)this.get(FLD_PEXF));
        double vpe = ArtikelstammItem.checkZeroDouble((String)this.get(FLD_PKG_SIZE));
        double vke = ArtikelstammItem.checkZeroDouble((String)this.get("Verkaufseinheit"));
        if (vpe > 0.0 && vke > 0.0 && vpe != vke) {
            return new Money(vke * (vkt / vpe));
        }
        return new Money(vkt);
    }

    public int getVerpackungsEinheit() {
        return Math.abs(ArtikelstammItem.checkZero((Object)this.get(FLD_PKG_SIZE)));
    }

    public Money getEKPreis() {
        String value = this.get(FLD_PEXF);
        if (value != null && !value.isEmpty()) {
            return new Money(Double.parseDouble(value));
        }
        return new Money();
    }

    public Money getVKPreis() {
        String value = this.get(FLD_PPUB);
        if (value != null && !value.isEmpty()) {
            double dValue = Double.parseDouble(value);
            return new Money(Math.abs(dValue));
        }
        return MargePreference.calculateVKP(this.getEKPreis());
    }

    public boolean isCalculatedPrice() {
        String value = this.get(FLD_PPUB);
        if (value != null && !value.isEmpty()) {
            return false;
        }
        String exfValue = this.get(FLD_PEXF);
        return exfValue != null && !exfValue.isEmpty();
    }

    public void setUserDefinedPrice(boolean activate) {
        if (activate) {
            String ppub = this.get(FLD_PPUB);
            this.setExtInfoStoredObjectByKey(EXTINFO_VAL_PPUB_OVERRIDE_STORE, ppub);
            double value = 0.0;
            try {
                value = Double.valueOf(ppub);
            }
            catch (NumberFormatException nfe) {
                log.error("Error #setUserDefinedPrice [{}] value is [{}], setting 0", (Object)this.getId(), (Object)ppub);
            }
            this.setUserDefinedPriceValue(value);
        } else {
            String ppubStored = (String)this.getExtInfoStoredObjectByKey(EXTINFO_VAL_PPUB_OVERRIDE_STORE);
            this.set(FLD_PPUB, ppubStored);
            this.setExtInfoStoredObjectByKey(EXTINFO_VAL_PPUB_OVERRIDE_STORE, null);
        }
    }

    public void setUserDefinedPriceValue(Double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("value must not be lower than 0");
        }
        this.set(FLD_PPUB, "-" + value);
    }

    public Double getUserDefinedPriceValue() {
        String ppub = this.get(FLD_PPUB);
        if (ppub != null && ppub.startsWith("-")) {
            try {
                return Double.valueOf(ppub);
            }
            catch (NumberFormatException nfe) {
                log.error("Error #getUserDefinedPrice [{}] value is [{}], setting 0", (Object)this.getId(), (Object)ppub);
            }
        }
        return null;
    }

    public boolean isUserDefinedPrice() {
        return this.getUserDefinedPriceValue() != null;
    }

    public void overrideVatInfo(IVerrechenbar.VatInfo overridenVat) {
        IVerrechenbar.VatInfo originalVatInfo = this.getOriginalVatInfo();
        if (overridenVat == originalVatInfo) {
            this.setExtInfoStoredObjectByKey(EXTINFO_VAL_VAT_OVERRIDEN, null);
        } else {
            this.setExtInfoStoredObjectByKey(EXTINFO_VAL_VAT_OVERRIDEN, overridenVat.toString());
        }
    }

    public String getExt(String name) {
        if (name.equals("Kassentyp")) {
            return this.isInSLList() ? "1" : "0";
        }
        return super.getExt(name);
    }

    private IVerrechenbar.VatInfo getOriginalVatInfo() {
        switch (this.getType()) {
            case P: {
                return IVerrechenbar.VatInfo.VAT_CH_ISMEDICAMENT;
            }
            case N: {
                return IVerrechenbar.VatInfo.VAT_CH_NOTMEDICAMENT;
            }
        }
        return IVerrechenbar.VatInfo.VAT_NONE;
    }

    public IVerrechenbar.VatInfo getVatInfo() {
        String overridenVat = (String)this.getExtInfoStoredObjectByKey(EXTINFO_VAL_VAT_OVERRIDEN);
        if (overridenVat != null) {
            return IVerrechenbar.VatInfo.valueOf((String)overridenVat);
        }
        return this.getOriginalVatInfo();
    }

    public IOptifier getOptifier() {
        if (!this.isInSLList()) {
            return noObligationOptifier;
        }
        return defaultOptifier;
    }

    public int getPreis(TimeTool dat, IFall fall) {
        double vkPreis = ArtikelstammItem.checkZeroDouble((String)this.getVKPreis().getCentsAsString());
        double pkgSize = Math.abs(ArtikelstammItem.checkZeroDouble((String)this.get(FLD_PKG_SIZE)));
        double vkUnits = ArtikelstammItem.checkZeroDouble((String)this.get("Verkaufseinheit"));
        if (pkgSize > 0.0 && vkUnits > 0.0 && pkgSize != vkUnits) {
            return (int)Math.round(vkUnits * (vkPreis / pkgSize));
        }
        return (int)Math.round(vkPreis);
    }

    public int getTP(TimeTool date, IFall fall) {
        return this.getPreis(date, fall);
    }

    public double getFactor(TimeTool date, IFall fall) {
        return 1.0;
    }

    public boolean isDragOK() {
        return true;
    }

    public String getXidDomain() {
        return "Artikelstamm";
    }

    public String getCodeSystemName() {
        return "Artikelstamm";
    }

    public String getCodeSystemCode() {
        String gtin = this.getGTIN();
        if (gtin != null && gtin.length() > 3) {
            if (this.getType() == ArtikelstammConstants.TYPE.P || this.isInSLList()) {
                return "402";
            }
            if (this.getType() == ArtikelstammConstants.TYPE.N) {
                return "406";
            }
        }
        return super.getCodeSystemCode();
    }

    public String getCode() {
        String gtin = this.getGTIN();
        if (gtin != null && gtin.length() > 3) {
            return gtin;
        }
        return this.get(FLD_PHAR);
    }

    public String getPharmaCode() {
        return this.get(FLD_PHAR);
    }

    public String getText() {
        return this.getLabel();
    }

    public String getEAN() {
        return this.get(FLD_GTIN);
    }

    public String getATC_code() {
        return this.getATCCode();
    }

    public int getVerkaufseinheit() {
        return ArtikelstammItem.checkZero((Object)this.get("Verkaufseinheit"));
    }

    public static DATASOURCEType getDatasourceType() {
        String dst = ArtikelstammItem.load(VERSION_ENTRY_ID).get(FLD_ADDDSCR);
        return DATASOURCEType.fromValue((String)dst);
    }

    public static void setDataSourceType(DATASOURCEType datasource) {
        log.info("Setting data source type [{}]", (Object)datasource.value());
        ArtikelstammItem.load(VERSION_ENTRY_ID).set(FLD_ADDDSCR, datasource.value());
    }

    public static int getCurrentVersion() {
        ArtikelstammItem version = ArtikelstammItem.load(VERSION_ENTRY_ID);
        return version.getInt(FLD_PPUB);
    }

    public static void setCurrentVersion(int importStammVersion) {
        ArtikelstammItem version = ArtikelstammItem.load(VERSION_ENTRY_ID);
        version.setInt(FLD_PPUB, importStammVersion);
    }

    public static void setImportSetCreationDate(Date creationDate) {
        ArtikelstammItem version = ArtikelstammItem.load(VERSION_ENTRY_ID);
        version.set(FLD_DSCR, df.format(creationDate.getTime()));
    }

    @Nullable
    public static Date getImportSetCreationDate() {
        ArtikelstammItem version = ArtikelstammItem.load(VERSION_ENTRY_ID);
        try {
            return df.parse(version.get(FLD_DSCR));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean purgeEntries(List<ArtikelstammItem> list) {
        if (list.size() == 0) {
            return true;
        }
        String string = list.stream().map(o -> o.getWrappedId()).reduce((u, t) -> String.valueOf(u) + "," + t).get();
        JdbcLink.Stm stm = ArtikelstammItem.getConnection().getStatement();
        stm.exec("DELETE FROM ARTIKELSTAMM_CH WHERE ID IN (" + string + ")");
        ArtikelstammItem.getConnection().releaseStatement(stm);
        return true;
    }

    public boolean isBlackBoxed() {
        String val = this.get(FLD_BLACKBOXED);
        return !"0".equals(val);
    }

    public BlackBoxReason getBlackBoxReason() {
        int value = Integer.parseInt(this.get(FLD_BLACKBOXED));
        return BlackBoxReason.getByInteger((int)value);
    }

    public String getDSCR() {
        return this.get(FLD_DSCR);
    }

    public String getGTIN() {
        return this.get(FLD_GTIN);
    }

    public String getPHAR() {
        return this.get(FLD_PHAR);
    }

    public String getATCCode() {
        return this.get(FLD_ATC);
    }

    public void setATCCode(String ATC_code) {
        this.set(FLD_ATC, ATC_code);
    }

    public ArtikelstammConstants.TYPE getType() {
        try {
            String string = this.get(FLD_ITEM_TYPE);
            if (string != null && string.length() > 0) {
                return Enum.valueOf(ArtikelstammConstants.TYPE.class, Character.toString(string.charAt(0)).toUpperCase());
            }
            log.warn("No TYPE argument for " + this.getId() + " found, defaulting to N (NonPharma).");
            return ArtikelstammConstants.TYPE.N;
        }
        catch (IllegalArgumentException iae) {
            log.error("Invalid TYPE argument for " + this.getId() + ": " + this.get(FLD_ITEM_TYPE));
            return null;
        }
    }

    public String getManufacturerLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.get(FLD_COMP_NAME) != null && this.get(FLD_COMP_NAME).length() > 1) {
            sb.append(this.get(FLD_COMP_NAME));
        }
        if (this.get(FLD_COMP_GLN) != null && this.get(FLD_COMP_GLN).length() > 1) {
            sb.append(" (GLN " + this.get(FLD_COMP_GLN) + ")");
        }
        return sb.toString();
    }

    public Double getExFactoryPrice() {
        return this.getEKPreis().doubleValue();
    }

    public Double getPublicPrice() {
        return this.getVKPreis().doubleValue();
    }

    public void setPublicPrice(Double amount) {
        if (this.isUserDefinedPrice()) {
            this.setUserDefinedPriceValue(amount);
        } else {
            this.set(FLD_PPUB, Double.toString(amount));
        }
    }

    public boolean isInSLList() {
        return this.get(FLD_SL_ENTRY) != null && this.get(FLD_SL_ENTRY).equals("1");
    }

    public String getSwissmedicCategory() {
        return this.get(FLD_IKSCAT);
    }

    public String getGenericType() {
        return this.get(FLD_GENERIC_TYPE);
    }

    public Integer getDeductible() {
        String val = this.get(FLD_DEDUCTIBLE);
        if (val == null || val.length() < 1) {
            if (this.isInSLList()) {
                return 0;
            }
            return -1;
        }
        try {
            return new Integer(val.trim());
        }
        catch (NumberFormatException nfe) {
            log.warn("Error parsing deductible [{}]", (Object)val.trim());
            return 0;
        }
    }

    public boolean isNarcotic() {
        return this.get(FLD_NARCOTIC).equals("1");
    }

    public boolean isLimited() {
        return this.get(FLD_LIMITATION).equals("1");
    }

    public String getLimitationPoints() {
        return this.get(FLD_LIMITATION_PTS);
    }

    public String getLimitationText() {
        return this.get(FLD_LIMITATION_TEXT);
    }

    public boolean isInLPPV() {
        return this.get(FLD_LPPV).equals("1");
    }

    public boolean isUserDefinedPkgSize() {
        return this.getUserDefinedPkgSize() != IS_USER_DEFINED_PKG_SIZE;
    }

    public void setUserDefinedPkgSize(boolean activate) {
        if (activate) {
            int value = IS_USER_DEFINED_PKG_SIZE;
            String pkgSize = this.get(FLD_PKG_SIZE);
            try {
                value = new Integer(pkgSize.trim());
            }
            catch (NumberFormatException nfe) {
                log.error("Error #setUserDefinedPrice [{}] value is [{}], setting 0", (Object)this.getId(), (Object)pkgSize);
                pkgSize = "0";
            }
            this.setExtInfoStoredObjectByKey(EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE, pkgSize);
            this.setUserDefinedPkgSizeValue(value);
        } else {
            String ppubStored = (String)this.getExtInfoStoredObjectByKey(EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE);
            this.set(FLD_PKG_SIZE, ppubStored);
            this.setExtInfoStoredObjectByKey(EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE, null);
        }
    }

    public void setUserDefinedPkgSizeValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must not be lower than 0");
        }
        log.debug("setUserDefinedPkgSizeValue Verpackungseinheit gtin  {}  value {}", (Object)this.getGTIN(), (Object)value);
        this.set(FLD_PKG_SIZE, "-" + value);
    }

    public int getUserDefinedPkgSize() {
        String oldValue = this.get(FLD_PKG_SIZE);
        if (oldValue != null && oldValue.startsWith("-")) {
            try {
                return -new Integer(oldValue.trim()).intValue();
            }
            catch (NumberFormatException nfe) {
                log.error("Error #getUserDefinedVerpackungseinheit [{}] value is [{}], setting 0", (Object)this.getId(), (Object)oldValue);
                return IS_USER_DEFINED_PKG_SIZE;
            }
        }
        return IS_USER_DEFINED_PKG_SIZE;
    }

    public int getVerpackungseinheit() {
        return Math.abs(this.getVerpackungsEinheit());
    }

    public void setVerpackungseinheit(int vpe) {
        log.debug("phar {} gtin {} setVerpackungseinheit {} is {} ", new Object[]{this.getPHAR(), this.getGTIN(), vpe, this.getVerpackungseinheit()});
        if (vpe != this.getVerpackungseinheit()) {
            this.setUserDefinedPkgSizeValue(vpe);
        } else {
            this.set(FLD_PKG_SIZE, String.valueOf(vpe));
        }
    }

    public void setVerkaufseinheit(int vse) {
        this.set("Verkaufseinheit", String.valueOf(vse));
    }

    public static int findNumberOfArtikelstammItemsForATCWildcard(String atcCode) {
        return PersistentObject.getConnection().queryInt("SELECT COUNT(*) FROM ARTIKELSTAMM_CH WHERE ATC LIKE " + JdbcLink.wrap((String)(String.valueOf(atcCode) + "%")));
    }

    @NonNull
    public List<ArtikelstammItem> getAlternativeArticlesByATCGroup() {
        String code = this.getATC_code();
        if (code == null || code.length() < 1) {
            return Collections.emptyList();
        }
        Query qre = new Query(ArtikelstammItem.class);
        qre.add(FLD_ATC, "=", code);
        return qre.execute();
    }

    @Nullable
    public static ArtikelstammItem findByEANorGTIN(@NonNull String ean) {
        Query qre = new Query(ArtikelstammItem.class);
        qre.add(FLD_GTIN, "LIKE", ean);
        qre.add(FLD_BLACKBOXED, "=", Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()));
        List result = qre.execute();
        if (result.size() == 1) {
            return (ArtikelstammItem)((Object)result.get(0));
        }
        return null;
    }

    @Nullable
    public static ArtikelstammItem findByPharmaCode(@NonNull String pharmaCode) {
        Query qre = new Query(ArtikelstammItem.class);
        qre.add(FLD_PHAR, "LIKE", pharmaCode);
        List result = qre.execute();
        if (result.size() == 1) {
            return (ArtikelstammItem)((Object)result.get(0));
        }
        if (!pharmaCode.startsWith(String.valueOf(0))) {
            return ArtikelstammItem.findByPharmaCode(String.valueOf(String.valueOf(0)) + pharmaCode);
        }
        return null;
    }

    public int getCacheTime() {
        return 300;
    }

    public String getProductId() {
        if (this.isProduct()) {
            return this.getId();
        }
        return ArtikelstammItem.checkNull((Object)this.get(FLD_PRODNO));
    }
}

