/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.provider.atccache;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.elexis.common.internal.ATCCodeServiceConsumer;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.NamedBlob2;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATCCodeCache {
    private static ATCCodeService atcCodeService = ATCCodeServiceConsumer.getATCCodeService();
    private static HashMap<String, Integer> cache;
    private static Logger log;
    private static final String NAMED_BLOB_PREFIX = "ATC_ARTSTAMM_CACHE";

    static {
        log = LoggerFactory.getLogger(ATCCodeCache.class);
    }

    private static void initCache() throws IOException, ClassNotFoundException {
        ATCCodeCache.deserializeFromDatabase(ATCCodeCache.determineBlobId());
    }

    private static String determineBlobId() {
        return "ATC_ARTSTAMM_CACHE_" + ArtikelstammItem.getCurrentVersion();
    }

    private static void deserializeFromDatabase(String id) throws IOException, ClassNotFoundException {
        NamedBlob2 cacheStorage = NamedBlob2.load((String)id);
        if (cacheStorage != null) {
            ByteArrayInputStream ba = new ByteArrayInputStream(cacheStorage.getBytes());
            ObjectInputStream oba = new ObjectInputStream(ba);
            cache = (HashMap)oba.readObject();
            oba.close();
            ba.close();
        } else {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(UiDesk.getTopShell());
            try {
                pmd.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ATCCodeCache.rebuildCache(monitor);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getAvailableArticlesByATCCode(ATCCode element) {
        Integer value;
        if (cache == null) {
            try {
                ATCCodeCache.initCache();
            }
            catch (IOException | ClassNotFoundException e) {
                log.error("Error initializing cache", (Throwable)e);
                cache = null;
                return -1;
            }
        }
        return (value = cache.get(element.atcCode)) != null ? value : 0;
    }

    public static void rebuildCache(IProgressMonitor monitor) {
        if (atcCodeService == null) {
            return;
        }
        List allATCCodes = atcCodeService.getAllATCCodes();
        int numberOfATCCodes = allATCCodes.size();
        monitor.beginTask("Rebuilding index of available articles per ATC Code", numberOfATCCodes + 1);
        cache = new HashMap(numberOfATCCodes);
        TreeMap<String, Integer> tm = new TreeMap<String, Integer>();
        String query = "SELECT DISTINCT(ATC) FROM ARTIKELSTAMM_CH";
        log.debug("ArtikelstammImporter {} numberOfATCCodes using query {}:", (Object)numberOfATCCodes, (Object)query);
        JdbcLink.Stm stm = PersistentObject.getConnection().getStatement();
        ResultSet rs = stm.query(query);
        try {
            while (rs.next()) {
                String atc = rs.getString(1);
                if (atc == null) continue;
                if (!tm.containsKey(atc)) {
                    tm.put(atc, 0);
                }
                Integer integer = (Integer)tm.get(atc);
                tm.put(atc, integer + 1);
            }
            rs.close();
        }
        catch (SQLException atc) {
            // empty catch block
        }
        PersistentObject.getConnection().releaseStatement(stm);
        for (ATCCode atcCode : allATCCodes) {
            int foundElements = 0;
            ATCCode next = atcCodeService.getNextInHierarchy(atcCode);
            SortedMap subMap = next != null ? tm.subMap(atcCode.atcCode, next.atcCode) : tm.tailMap(atcCode.atcCode);
            for (String val : subMap.keySet()) {
                foundElements += ((Integer)tm.get(val)).intValue();
            }
            cache.put(atcCode.atcCode, foundElements);
            monitor.worked(1);
        }
        monitor.subTask("Persisting ATC Code product cache to database");
        NamedBlob2.cleanup((String)NAMED_BLOB_PREFIX, (TimeTool)new TimeTool());
        try {
            NamedBlob2 cacheStorage = NamedBlob2.create((String)ATCCodeCache.determineBlobId(), (boolean)false);
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ObjectOutputStream oba = new ObjectOutputStream(ba);
            oba.writeObject(cache);
            oba.close();
            cacheStorage.putBytes(ba.toByteArray());
            ba.close();
            monitor.worked(1);
        }
        catch (IOException e) {
            log.error("Error on cache generation", (Throwable)e);
        }
        monitor.done();
    }
}

