/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.dbcheck;

import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixPrescriptionArtikelstammReferences
extends ExternalMaintenance {
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder sb = new StringBuilder();
        Query qre = new Query(Prescription.class);
        qre.add("Artikel", "LIKE", String.valueOf(ArtikelstammItem.class.getName()) + "%");
        List execute = qre.execute();
        pm.beginTask("Fixing references", qre.size());
        int total = execute.size();
        int fixed = 0;
        int failed = 0;
        for (Prescription pres : execute) {
            Artikel artikel = pres.getArtikel();
            if (!artikel.exists()) {
                String string = pres.get("Artikel");
                String replaceAll = string.replaceAll("ch.artikelstamm.elexis.common.ArtikelstammItem::", "");
                String substring = replaceAll.substring(0, replaceAll.length() - 4);
                String itemId = PersistentObject.getConnection().queryString("SELECT ID FROM ARTIKELSTAMM_CH WHERE id LIKE " + JdbcLink.wrap((String)(String.valueOf(substring) + "%")));
                ArtikelstammItem load = ArtikelstammItem.load(itemId);
                if (load.exists()) {
                    ++fixed;
                    sb.append("Fixing [" + pres.getId() + "] " + string + " -> " + load.getId() + "\n");
                    pres.set("Artikel", load.storeToString());
                } else {
                    ++failed;
                    sb.append("Error fixing [" + pres.getId() + "] on article [" + pres.get("Artikel") + "]\n");
                }
            }
            pm.worked(1);
        }
        sb.append("Total " + total + " / Fixed " + fixed + "/ Failed " + failed + "\n");
        pm.done();
        return sb.toString();
    }

    public String getMaintenanceDescription() {
        return "[5285] Fix references from Prescriptions to ArtikelstammItems";
    }
}

