/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.dbcheck;

import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.IVerrechnetAdjuster;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.ExHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddMissingVATToVerrechenbarArticles
extends ExternalMaintenance {
    private static ArrayList<IVerrechnetAdjuster> adjusters = new ArrayList();

    static {
        List adjustersConfigurations = Extensions.getExtensions((String)"ch.elexis.core.data.VerrechnungscodeAdjuster");
        for (IConfigurationElement elem : adjustersConfigurations) {
            try {
                Object o = elem.createExecutableExtension("class");
                if (!(o instanceof IVerrechnetAdjuster)) continue;
                adjusters.add((IVerrechnetAdjuster)o);
            }
            catch (CoreException e) {
                ExHandler.handle((Throwable)e);
            }
        }
    }

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        Query qbe = new Query(Verrechnet.class);
        qbe.add("Klasse", "LIKE", "ch.artikelstamm.elexis.common.ArtikelstammItem");
        List qre = qbe.execute();
        output.append("Folgende Adjuster werden angewendet:\n");
        for (IVerrechnetAdjuster adjuster : adjusters) {
            output.append("\t" + adjuster.getClass().getName() + "\n");
        }
        output.append("--------------------------------\n");
        pm.beginTask("Verifiziere Artikelstamm-Leistungen ....", qre.size());
        for (Verrechnet vr : qre) {
            IVerrechenbar verrechenbar;
            String verrechnet_vatscale = vr.getDetail("vat_scale");
            if (verrechnet_vatscale == null && (verrechenbar = vr.getVerrechenbar()) instanceof ArtikelstammItem) {
                for (IVerrechnetAdjuster adjuster : adjusters) {
                    output.append("Erg\u00e4nze fehlende Info bei Verrechnet " + vr.getId() + " (Kons " + vr.getKons().getLabel() + ")\n");
                    adjuster.adjust(vr);
                }
            }
            pm.worked(1);
        }
        output.append("DONE\n");
        pm.done();
        return output.toString();
    }

    public String getMaintenanceDescription() {
        return "[4947] Fehlende MWSt Information f\u00fcr RH eingende Artikel korrigieren";
    }
}

