/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.swt.ResourceManager;

public class BlackboxViewerFilterAction
extends Action {
    private FlatDataLoader fdl;
    private PersistentObjectLoader.QueryFilter blackboxOnlyFilter = new BlackboxOnlyQueryFilter();
    private SelectorPanelProvider slp;
    private static final String FILTER_CFG = "BlackboxViewerFilterAction.showInactiveItems";

    public BlackboxViewerFilterAction(FlatDataLoader fdl, SelectorPanelProvider selectorPanel) {
        this.fdl = fdl;
        this.slp = selectorPanel;
        boolean value = CoreHub.userCfg.get(FILTER_CFG, false);
        this.setChecked(value);
        this.addOrRemoveFilter();
    }

    public ImageDescriptor getImageDescriptor() {
        return ResourceManager.getPluginImageDescriptor((String)"at.medevit.ch.artikelstamm.ui", (String)"/rsc/icons/flag-black.png");
    }

    public int getStyle() {
        return 2;
    }

    public String getToolTipText() {
        return "Inaktive Items anzeigen";
    }

    private void addOrRemoveFilter() {
        if (this.isChecked()) {
            this.fdl.removeQueryFilter(this.blackboxOnlyFilter);
        } else {
            this.fdl.addQueryFilter(this.blackboxOnlyFilter);
        }
    }

    public void run() {
        this.addOrRemoveFilter();
        this.fdl.applyQueryFilters();
        this.slp.getPanel().contentsChanged(null);
        CoreHub.userCfg.set(FILTER_CFG, this.isChecked());
    }

    public String getDescription() {
        return "Inkludiert inaktive Items in die Anzeige (schwarze Fahne)";
    }

    public String getText() {
        return "Inaktive Items";
    }

    private class BlackboxOnlyQueryFilter
    implements PersistentObjectLoader.QueryFilter {
        private BlackboxOnlyQueryFilter() {
        }

        public void apply(Query<? extends PersistentObject> qbe) {
            qbe.add("BB", "=", "0");
        }
    }
}

