/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.elexis.common.internal.ATCCodeServiceConsumer;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ATCFilterInfoListElement;
import at.medevit.ch.artikelstamm.elexis.common.ui.provider.atccache.ATCCodeCache;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.FlatDataLoader;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class ArtikelstammFlatDataLoader
extends FlatDataLoader
implements IDoubleClickListener {
    private ATCQueryFilter atcQueryFilter = new ATCQueryFilter();
    private boolean useAtcQueryFilter = false;
    private boolean useMephaPreferredSorter = false;
    private List filtered = null;
    private List raw = null;
    private SelectorPanelProvider slp;
    private String filterValueStore;

    public ArtikelstammFlatDataLoader(CommonViewer cv, Query<? extends PersistentObject> qbe, SelectorPanelProvider slp) {
        super(cv, qbe);
        this.slp = slp;
        this.setOrderFields(new String[]{"DSCR"});
        this.applyQueryFilters();
        this.addQueryFilter(new IncludeEANQueryFilter());
        this.addQueryFilter(new NoVersionQueryFilter());
        this.useMephaPreferredSorter = CoreHub.globalCfg.get("artikelstammPreferMepha", false);
    }

    public IStatus work(IProgressMonitor monitor, HashMap<String, Object> params) {
        if (this.isSuspended()) {
            return Status.CANCEL_STATUS;
        }
        final TableViewer tv = (TableViewer)this.cv.getViewerWidget();
        if (this.filtered != null) {
            this.filtered.clear();
        }
        this.setQuery();
        this.applyQueryFilters();
        if (this.useMephaPreferredSorter) {
            this.qbe.addToken(" 1=1 ORDER BY CASE WHEN COMP_GLN='7601001001121' THEN 1 ELSE 2 END, DSCR ASC");
        } else if (this.orderFields != null) {
            this.qbe.orderBy(false, this.orderFields);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.raw = this.qbe.execute();
        if (this.useAtcQueryFilter) {
            if (!this.atcQueryFilter.isActive()) {
                this.insertATCCodeValues(params);
            } else {
                this.addFilterInformation();
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (tv != null && !tv.getTable().isDisposed()) {
                    tv.setItemCount(0);
                    ArtikelstammFlatDataLoader.this.filtered = ArtikelstammFlatDataLoader.this.raw;
                    tv.setItemCount(ArtikelstammFlatDataLoader.this.raw.size());
                }
            }
        });
        return Status.OK_STATUS;
    }

    private void addFilterInformation() {
        String atcInfo = ATCCodeServiceConsumer.getATCCodeService().getForATCCode((String)((ATCQueryFilter)this.atcQueryFilter).atcFilter).name_german;
        String label = "ATC Filter " + this.atcQueryFilter.atcFilter + " (" + atcInfo + ")";
        ATCFilterInfoListElement aficle = new ATCFilterInfoListElement(label);
        this.raw.add(0, aficle);
    }

    private void insertATCCodeValues(HashMap<String, Object> params) {
        HashMap fieldValuesHashmap = (HashMap)params.get("fieldvalues");
        if (fieldValuesHashmap == null) {
            return;
        }
        String name = (String)fieldValuesHashmap.get("DSCR");
        if (name == null || name.length() < 1) {
            return;
        }
        ATCCodeService atcCodeService = ATCCodeServiceConsumer.getATCCodeService();
        if (atcCodeService == null) {
            return;
        }
        List results = atcCodeService.getATCCodesMatchingName(name, 1, 1);
        boolean showEmptyGroups = CoreHub.globalCfg.get("artikelstamm/showAtcGropsWoArticles", true);
        if (!showEmptyGroups) {
            for (ATCCode atcCode : results) {
                if (ATCCodeCache.getAvailableArticlesByATCCode(atcCode) <= 0) continue;
                this.raw.add(atcCode);
            }
        } else {
            this.raw.addAll(0, results);
        }
    }

    public void setResult(List<PersistentObject> res) {
        this.raw = res;
    }

    protected void setQuery() {
        this.qbe.clear();
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            cfp.setQuery(this.qbe);
        }
    }

    public void updateElement(int index) {
        if (this.filtered != null && !this.filtered.isEmpty()) {
            Object o;
            ArrayList filteredCopy = new ArrayList(this.filtered);
            if (index >= 0 && index < filteredCopy.size() && (o = filteredCopy.get(index)) != null) {
                TableViewer tv = (TableViewer)this.cv.getViewerWidget();
                tv.replace(filteredCopy.get(index), index);
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (selection.getFirstElement() == null) {
            return;
        }
        if (selection.getFirstElement() instanceof ATCCode) {
            this.filterValueStore = this.slp.getValues()[0];
            this.slp.clearValues();
            ATCCode a = (ATCCode)selection.getFirstElement();
            this.setAtcQueryFilterValue(a.atcCode);
        } else if (selection.getFirstElement() instanceof ATCFilterInfoListElement) {
            this.slp.clearValues();
            ActiveControl ac = (ActiveControl)this.slp.getPanel().getControls().get(0);
            ac.setText(this.filterValueStore != null ? this.filterValueStore : "");
            this.setAtcQueryFilterValue(null);
        }
    }

    public void setAtcQueryFilterValue(String filterValue) {
        if (filterValue == null) {
            this.removeQueryFilter(this.atcQueryFilter);
            this.atcQueryFilter.setAtcFilter(null);
        } else {
            this.atcQueryFilter.setAtcFilter(filterValue);
            this.addQueryFilter(this.atcQueryFilter);
        }
        this.job.schedule();
    }

    public void setUseAtcQueryFilter(boolean useAtcQueryFilter) {
        this.useAtcQueryFilter = useAtcQueryFilter;
        if (!useAtcQueryFilter) {
            this.removeQueryFilter(this.atcQueryFilter);
            this.atcQueryFilter.setAtcFilter(null);
        }
        this.job.schedule();
    }

    public boolean isUseAtcQueryFilter() {
        return this.useAtcQueryFilter;
    }

    public void setUseMephaPrefferedProviderSorter(boolean doPreferMepha) {
        this.useMephaPreferredSorter = doPreferMepha;
        this.job.schedule();
    }

    private class ATCQueryFilter
    implements PersistentObjectLoader.QueryFilter {
        private String atcFilter;

        private ATCQueryFilter() {
        }

        public void apply(Query<? extends PersistentObject> qbe) {
            qbe.add("ATC", "LIKE", String.valueOf(this.atcFilter) + "%");
        }

        public void setAtcFilter(String atcFilter) {
            this.atcFilter = atcFilter;
        }

        public String getAtcFilter() {
            return this.atcFilter;
        }

        public boolean isActive() {
            return this.atcFilter != null;
        }
    }

    private class IncludeEANQueryFilter
    implements PersistentObjectLoader.QueryFilter {
        private IncludeEANQueryFilter() {
        }

        public void apply(Query<? extends PersistentObject> qbe) {
            String eanValue;
            if (ArtikelstammFlatDataLoader.this.slp.getValues() != null && (eanValue = ArtikelstammFlatDataLoader.this.slp.getValues()[0]).length() > 0 && StringUtils.isNumeric((String)eanValue)) {
                qbe.or();
                qbe.add("GTIN", "LIKE", String.valueOf(eanValue) + "%");
            }
        }
    }

    private class NoVersionQueryFilter
    implements PersistentObjectLoader.QueryFilter {
        private NoVersionQueryFilter() {
        }

        public void apply(Query<? extends PersistentObject> qbe) {
            qbe.and();
            qbe.add("ID", "<>", "VERSION");
        }
    }
}

