/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.ch.artikelstamm.elexis.common.internal.ATCCodeServiceConsumer;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ArtikelstammFlatDataLoader;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ATCMenuContributionItem
extends ContributionItem {
    private final CommonViewer cov;
    private final String prefAtcLanguage;
    private final ArtikelstammFlatDataLoader fdl;

    public ATCMenuContributionItem(CommonViewer cov, ArtikelstammFlatDataLoader fdl) {
        this.cov = cov;
        this.fdl = fdl;
        this.prefAtcLanguage = CoreHub.globalCfg.get("artikelstamm/atcCodeLanguage", "ger");
    }

    public void fill(Menu menu, int index) {
        StructuredSelection structuredSelection = new StructuredSelection(this.cov.getSelection());
        Object element = structuredSelection.getFirstElement();
        ATCCodeService atcCodeService = ATCCodeServiceConsumer.getATCCodeService();
        if (atcCodeService == null) {
            return;
        }
        if (element instanceof ArtikelstammItem) {
            ArtikelstammItem ai = (ArtikelstammItem)((Object)element);
            List atcHierarchy = atcCodeService.getHierarchyForATCCode(ai.getATCCode());
            for (ATCCode atcCode : atcHierarchy) {
                MenuItem temp = new MenuItem(menu, 8);
                if (this.prefAtcLanguage.equals("ger")) {
                    temp.setText(String.valueOf(atcCode.atcCode) + " " + atcCode.name_german);
                } else {
                    temp.setText(String.valueOf(atcCode.atcCode) + " " + atcCode.name);
                }
                final ATCCode tempC = atcCode;
                temp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ATCMenuContributionItem.this.fdl.setUseAtcQueryFilter(true);
                        ATCMenuContributionItem.this.fdl.setAtcQueryFilterValue(tempC.atcCode);
                    }
                });
            }
        }
    }

    public boolean isDynamic() {
        return true;
    }
}

