/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui;

import at.medevit.ch.artikelstamm.ArtikelstammHelper;
import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.ui.DetailComposite;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.controls.StockDetailComposite;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import java.util.Date;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;

public class DetailDisplay
implements IDetailDisplay {
    private UpdateValueStrategy integerToString = new UpdateValueStrategy().setConverter((IConverter)NumberToStringConverter.fromInteger((boolean)false));
    private UpdateValueStrategy stringToInteger = new UpdateValueStrategy().setConverter((IConverter)StringToNumberConverter.toInteger((boolean)false));
    protected WritableValue item = new WritableValue(null, ArtikelstammItem.class);
    private DetailComposite dc = null;
    private StockDetailComposite sdc;
    private Text txtStkProPack;
    private Text txtStkProAbgabe;

    public Class<? extends PersistentObject> getElementClass() {
        return ArtikelstammItem.class;
    }

    public void display(Object obj) {
        ArtikelstammItem ai = (ArtikelstammItem)((Object)obj);
        this.item.setValue((Object)ai);
        if (this.dc != null) {
            this.dc.setItem((IArtikelstammItem)ai);
        }
        if (this.sdc != null && !this.sdc.isDisposed()) {
            this.sdc.setArticle((Artikel)ai);
        }
        if (!this.txtStkProAbgabe.isDisposed()) {
            this.txtStkProAbgabe.setEnabled(!ai.isProduct());
        }
        if (!this.txtStkProPack.isDisposed()) {
            this.txtStkProPack.setEnabled(!ai.isProduct());
        }
    }

    public String getTitle() {
        return "Artikelstamm";
    }

    public Composite createDisplay(Composite parent, IViewSite site) {
        if (this.dc == null) {
            String atcLang = CoreHub.globalCfg.get("artikelstamm/atcCodeLanguage", "ger");
            this.dc = new DetailComposite(parent, 768, atcLang);
            this.addLagerhaltungGroupToComposite(this.dc);
            this.addAdditionalInformation(this.dc);
            this.addDataSetStateLabelToComposite(this.dc);
        }
        return this.dc;
    }

    public void addAdditionalInformation(DetailComposite dc) {
    }

    private void addDataSetStateLabelToComposite(DetailComposite dc) {
        Date creationDate;
        Composite ret = new Composite(dc.getMainComposite(), 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)new GridData(4, 512, true, false));
        Label label = new Label(ret, 0);
        label.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        StringBuilder sb = new StringBuilder();
        int version = ArtikelstammItem.getCurrentVersion();
        if (version != 99999) {
            sb.append(" v" + version);
        }
        if ((creationDate = ArtikelstammItem.getImportSetCreationDate()) != null) {
            sb.append(" / " + ArtikelstammHelper.monthAndYearWritten.format(creationDate));
        }
        DATASOURCEType datasourceType = DATASOURCEType.ODDB_2_XML;
        try {
            datasourceType = ArtikelstammItem.getDatasourceType();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        sb.append(" / " + datasourceType.value());
        label.setText("Datensatz-Basis: " + sb.toString());
        this.addUpdateLabelToBottom(ret);
    }

    public void addUpdateLabelToBottom(Composite dc) {
    }

    private void addLagerhaltungGroupToComposite(DetailComposite dc) {
        DataBindingContext bindingContext = new DataBindingContext();
        Group grpLagerhaltung = new Group(dc.getMainComposite(), 0);
        grpLagerhaltung.setText("Lagerhaltung");
        grpLagerhaltung.setLayout((Layout)new GridLayout(4, false));
        grpLagerhaltung.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sdc = new StockDetailComposite((Composite)grpLagerhaltung, 0);
        GridData gridData = new GridData(4, 4, false, true, 4, 1);
        gridData.heightHint = 100;
        this.sdc.setLayoutData((Object)gridData);
        Label lblStkProPack = new Label((Composite)grpLagerhaltung, 0);
        lblStkProPack.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStkProPack.setText("Stk. pro Pckg.");
        this.txtStkProPack = new Text((Composite)grpLagerhaltung, 2048);
        this.txtStkProPack.setTextLimit(4);
        GridData gd_txtStkProPack = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtStkProPack.widthHint = 40;
        this.txtStkProPack.setLayoutData((Object)gd_txtStkProPack);
        IObservableValue propertyStkProPack = PojoProperties.value(ArtikelstammItem.class, (String)"verpackungseinheit", Integer.class).observeDetail((IObservableValue)this.item);
        ISWTObservableValue targetStkProPack = WidgetProperties.text((int)24).observe((Widget)this.txtStkProPack);
        bindingContext.bindValue((IObservableValue)targetStkProPack, propertyStkProPack, this.stringToInteger, this.integerToString);
        Label lblStkProAbgabe = new Label((Composite)grpLagerhaltung, 0);
        lblStkProAbgabe.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStkProAbgabe.setText("Stk. pro Abgabe");
        String tooltip = "F\u00fcr Komplettpackung bitte 0 Stk. angeben.";
        lblStkProAbgabe.setToolTipText("F\u00fcr Komplettpackung bitte 0 Stk. angeben.");
        this.txtStkProAbgabe = new Text((Composite)grpLagerhaltung, 2048);
        this.txtStkProAbgabe.setTextLimit(4);
        GridData gd_txtStkProAbgabe = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtStkProAbgabe.widthHint = 40;
        this.txtStkProAbgabe.setLayoutData((Object)gd_txtStkProAbgabe);
        this.txtStkProAbgabe.setToolTipText("F\u00fcr Komplettpackung bitte 0 Stk. angeben.");
        IObservableValue propertyStkProAbgabe = PojoProperties.value(ArtikelstammItem.class, (String)"verkaufseinheit", Integer.class).observeDetail((IObservableValue)this.item);
        ISWTObservableValue targetStkProAbgabe = WidgetProperties.text((int)24).observe((Widget)this.txtStkProAbgabe);
        bindingContext.bindValue((IObservableValue)targetStkProAbgabe, propertyStkProAbgabe, this.stringToInteger, this.integerToString);
    }
}

