/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.importer;

import at.medevit.ch.artikelstamm.ARTIKELSTAMM;
import at.medevit.ch.artikelstamm.ArtikelstammConstants;
import at.medevit.ch.artikelstamm.ArtikelstammHelper;
import at.medevit.ch.artikelstamm.BlackBoxReason;
import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.SALECDType;
import at.medevit.ch.artikelstamm.elexis.common.PluginConstants;
import at.medevit.ch.artikelstamm.elexis.common.ui.provider.atccache.ATCCodeCache;
import ch.artikelstamm.elexis.common.ArtikelstammItem;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ArtikelstammImporter {
    private static Logger log = LoggerFactory.getLogger(ArtikelstammImporter.class);
    private static Map<String, ARTIKELSTAMM.PRODUCTS.PRODUCT> products = new HashMap<String, ARTIKELSTAMM.PRODUCTS.PRODUCT>();
    private static Map<String, ARTIKELSTAMM.LIMITATIONS.LIMITATION> limitations = new HashMap<String, ARTIKELSTAMM.LIMITATIONS.LIMITATION>();
    private static volatile boolean userCanceled = false;
    private static boolean isOddb2xml = false;

    public static IStatus performImport(IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        return ArtikelstammImporter.performImport(monitor, input, true, true, newVersion);
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus performImport(IProgressMonitor monitor, InputStream input, boolean bPharma, boolean bNonPharma, @Nullable Integer newVersion) {
        lock = new LocalLock((Object)"ArtikelstammImporter");
        if (!lock.tryLock()) {
            UiDesk.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"", (String)("Der Importer ist durch einen anderen Benutzer gestartet.\nDie Artikelstammeintr\u00e4ge werden bereits importiert.\n\nStartzeit: " + new TimeTool(lock.getLockCurrentMillis()).toString(1) + "\nGestartet durch: " + lock.getLockMessage() + "\n\nWollen Sie den Importer trotzdem nochmal starten ?"))) {
                        lock.unlock();
                        lock.tryLock();
                        userCanceled = false;
                    } else {
                        userCanceled = true;
                    }
                }
            });
        }
        if (ArtikelstammImporter.userCanceled) {
            ArtikelstammImporter.userCanceled = false;
            return Status.OK_STATUS;
        }
        try {
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            bundleVersion = Platform.getBundle((String)"at.medevit.ch.artikelstamm.elexis.common").getVersion().toString();
            subMonitor.setTaskName("Einlesen der Aktualisierungsdaten");
            importStamm = null;
            try {
                importStamm = ArtikelstammHelper.unmarshallInputStream((InputStream)input);
            }
            catch (JAXBException | SAXException je) {
                msg = "Fehler beim Einlesen der Import-Datei";
                status = new ElexisStatus(4, PluginConstants.PLUGIN_ID, 1, msg, (Exception)je);
                StatusManager.getManager().handle((IStatus)status, 2);
                ArtikelstammImporter.log.error(msg, je);
                lock.unlock();
                var15_19 = Status.CANCEL_STATUS;
                lock.unlock();
                return var15_19;
            }
            subMonitor.worked(10);
            if (newVersion == null) {
                month = importStamm.getBUILDDATETIME().getMonth();
                year = importStamm.getBUILDDATETIME().getYear();
                newVersion = Integer.valueOf("" + (year - 2000) + month);
                ArtikelstammImporter.log.info("[PI] No newVersion provided. Setting to [{}].", (Object)newVersion);
            }
            try {
                datasourceType = ArtikelstammItem.getDatasourceType();
                message = "Trying to import dataset sourced [" + importStamm.getDATASOURCE().value() + "] while existent database is sourced [" + datasourceType.value() + "]. Please contact support. Exiting.";
                if (importStamm.getDATASOURCE() != datasourceType) {
                    ArtikelstammImporter.log.error(message);
                    lock.unlock();
                    var15_20 = new Status(4, PluginConstants.PLUGIN_ID, message);
                    return var15_20;
                }
                ** GOTO lbl42
            }
            catch (IllegalArgumentException iae) {
                ArtikelstammItem.setDataSourceType(importStamm.getDATASOURCE());
lbl42:
                // 2 sources

                currentVersion = ArtikelstammItem.getCurrentVersion();
                ArtikelstammImporter.log.info("[PI] Aktualisiere{}{} {} vom {} von v{} auf v{}. Importer-Version {}", new Object[]{bPharma != false ? " Pharma" : "", bNonPharma != false ? " NonPharma" : "", importStamm.getDATASOURCE(), importStamm.getCREATIONDATETIME().toGregorianCalendar().getTime(), currentVersion, newVersion, bundleVersion});
                subMonitor.setTaskName("Lese Produkte und Limitationen...");
                subMonitor.subTask("Lese Produkt-Details");
                ArtikelstammImporter.populateProducsAndLimitationsMap(importStamm);
                subMonitor.worked(5);
                subMonitor.setTaskName("Setze alle Elemente auf inaktiv...");
                subMonitor.subTask("Setze Elemente auf inaktiv");
                ArtikelstammImporter.isOddb2xml = importStamm.getDATASOURCE().equals((Object)DATASOURCEType.ODDB_2_XML);
                ArtikelstammImporter.inactivateNonBlackboxedItems();
                subMonitor.worked(5);
                startTime = System.currentTimeMillis();
                subMonitor.setTaskName("Importiere Artikelstamm " + importStamm.getCREATIONDATETIME().getMonth() + "/" + importStamm.getCREATIONDATETIME().getYear());
                if (bPharma) {
                    subMonitor.subTask("Importiere Pharma Products");
                    ArtikelstammImporter.updateOrAddProducts(newVersion, importStamm, (IProgressMonitor)subMonitor.split(20));
                }
                subMonitor.subTask("Importiere Artikel");
                ArtikelstammImporter.updateOrAddItems(newVersion, importStamm, bPharma, bNonPharma, (IProgressMonitor)subMonitor.split(50));
                subMonitor.setTaskName("Setze neue Versionsnummer");
                ArtikelstammItem.setCurrentVersion(newVersion);
                ArtikelstammItem.setImportSetCreationDate(importStamm.getCREATIONDATETIME().toGregorianCalendar().getTime());
                subMonitor.worked(5);
                endTime = System.currentTimeMillis();
                ElexisEventDispatcher.reload(ArtikelstammItem.class);
                ArtikelstammImporter.log.info("[PI] Artikelstamm import took " + (endTime - startTime) / 1000L + "sec.Used {} {} version {}. . Importer-Version {}. Will rebuild ATCCodeCache", new Object[]{ArtikelstammItem.getDatasourceType().toString(), ArtikelstammItem.getImportSetCreationDate(), newVersion, bundleVersion});
                ATCCodeCache.rebuildCache((IProgressMonitor)subMonitor.split(2));
                ArtikelstammImporter.log.info("[PI] Artikelstamm finished rebuilding ATCCodeCache");
                ArtikelstammImporter.validateLeistungsblockReferences(subMonitor.split(3));
                ArtikelstammImporter.log.info("[PI] Leistungsblock validation finished ");
            }
        }
        finally {
            lock.unlock();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateLeistungsblockReferences(SubMonitor subMonitor) {
        HashMap<String, void> nonResolvableArtikelstammItems = new HashMap<String, void>();
        List leistungsbloecke = new Query(Leistungsblock.class).execute();
        subMonitor.beginTask("Checking Artikelstamm-References in Leistungsblock", leistungsbloecke.size());
        for (Leistungsblock leistungsblock : leistungsbloecke) {
            void var5_5;
            List list = (List)nonResolvableArtikelstammItems.get(leistungsblock.getId());
            List elements = leistungsblock.getElements();
            List diffToReferences = leistungsblock.getDiffToReferences(elements);
            if (diffToReferences.size() > 0) {
                for (ICodeElement iCodeElement : diffToReferences) {
                    if (!"Artikelstamm".equals(iCodeElement.getCodeSystemName())) continue;
                    if (var5_5 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var5_5.add(String.valueOf(iCodeElement.getText()) + " [" + iCodeElement.getCode() + "]");
                }
            }
            if (var5_5 != null) {
                nonResolvableArtikelstammItems.put(leistungsblock.getCode(), var5_5);
            }
            subMonitor.worked(1);
        }
        Set entrySet = nonResolvableArtikelstammItems.entrySet();
        if (!entrySet.isEmpty()) {
            final StringBuilder sb = new StringBuilder();
            sb.append("Die folgenden Artikelstamm-Referenzen in den genannten Leistungsbl\u00f6cken sind nicht mehr aufl\u00f6sbar:\n\n");
            for (Map.Entry entry : entrySet) {
                sb.append(String.valueOf((String)entry.getKey()) + ":\n");
                List value = (List)entry.getValue();
                for (String string : value) {
                    sb.append("\t" + string + "\n");
                }
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Leistungsblock Artikelstamm-Referenzen", (String)sb.toString());
                }
            });
        }
    }

    private static void inactivateNonBlackboxedItems() {
        log.debug("[BB] Setting all items inactive for isOddb2xml {}...", (Object)isOddb2xml);
        JdbcLink.Stm stm = PersistentObject.getConnection().getStatement();
        String cmd = "UPDATE ARTIKELSTAMM_CH SET BB=" + JdbcLink.wrap((String)Integer.toString(BlackBoxReason.INACTIVE.getNumercialReason())) + " WHERE " + "BB" + "=" + JdbcLink.wrap((String)Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()));
        if (isOddb2xml) {
            cmd = String.valueOf(cmd) + " AND TYPE=" + JdbcLink.wrap((String)"P");
        }
        log.debug("Executing {}", (Object)cmd);
        stm.exec(cmd);
        log.debug("Done Executing {}", (Object)cmd);
        PersistentObject.getConnection().releaseStatement(stm);
    }

    private static void populateProducsAndLimitationsMap(ARTIKELSTAMM importStamm) {
        products = importStamm.getPRODUCTS().getPRODUCT().stream().collect(Collectors.toMap(p -> p.getPRODNO(), p -> p));
        limitations = importStamm.getLIMITATIONS().getLIMITATION().stream().collect(Collectors.toMap(l -> l.getLIMNAMEBAG(), l -> l));
    }

    private static void updateOrAddProducts(int newVersion, ARTIKELSTAMM importStamm, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        List importProductList = importStamm.getPRODUCTS().getPRODUCT();
        subMonitor.beginTask("Importiere " + importProductList.size() + " Produkte", importProductList.size());
        log.debug("[IP] Update or import {} products...", (Object)importProductList.size());
        for (ARTIKELSTAMM.PRODUCTS.PRODUCT product : importProductList) {
            String prodno = product.getPRODNO();
            ArtikelstammItem foundProduct = ArtikelstammItem.load(prodno);
            if (!foundProduct.exists()) {
                String trimmedDscr = ArtikelstammImporter.trimDSCR(product.getDSCR(), product.getPRODNO());
                foundProduct = new ArtikelstammItem(newVersion, ArtikelstammConstants.TYPE.X, product.getPRODNO(), null, trimmedDscr, "");
                log.trace("[IP] Adding product " + foundProduct.getId() + " (" + foundProduct.getDSCR() + ")");
            }
            log.trace("[IP] Updating product " + foundProduct.getId() + " (" + product.getDSCR() + ")");
            ArtikelstammImporter.setValuesOnArtikelstammProdukt(foundProduct, product, newVersion);
            subMonitor.worked(1);
        }
        subMonitor.done();
    }

    private static String trimDSCR(String dscr, String itemId) {
        if (dscr.length() > 100) {
            log.trace("[IP] Delimiting dscr [{}] for product/item [{}] to 100 characters.", (Object)itemId, (Object)dscr);
            dscr = dscr.substring(0, 100);
        }
        return dscr;
    }

    private static void setValuesOnArtikelstammProdukt(ArtikelstammItem ai, ARTIKELSTAMM.PRODUCTS.PRODUCT product, int cummulatedVersion) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        fields.add("BB");
        values.add(Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()));
        fields.add("CUMM_VERSION");
        values.add(String.valueOf(cummulatedVersion));
        fields.add("ATC");
        values.add(product.getATC());
        fields.add("DSCR");
        values.add(ArtikelstammImporter.trimDSCR(product.getDSCR(), product.getPRODNO()));
        ai.set(fields.toArray(new String[0]), values.toArray(new String[0]));
    }

    private static void updateOrAddItems(int newVersion, ARTIKELSTAMM importStamm, boolean bPharma, boolean bNonPharma, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        List importItemList = importStamm.getITEMS().getITEM();
        subMonitor.beginTask("Importiere " + importItemList.size() + " items", importItemList.size());
        log.debug("[II] Update or import {} items...", (Object)importItemList.size());
        for (ARTIKELSTAMM.ITEMS.ITEM item : importItemList) {
            Query qre = new Query(ArtikelstammItem.class);
            qre.add("GTIN", "LIKE", item.getGTIN());
            ArtikelstammItem foundItem = null;
            List result = qre.execute();
            if (result.size() > 0) {
                if (result.size() == 1) {
                    foundItem = (ArtikelstammItem)((Object)result.get(0));
                } else {
                    log.warn("[II] Found multiple items ({}) for GTIN [{}] type {}", new Object[]{result.size(), item.getGTIN(), item.getPHARMATYPE()});
                    for (ArtikelstammItem artikelstammItem : result) {
                        if (artikelstammItem.getBlackBoxReason() != BlackBoxReason.INACTIVE && (!isOddb2xml || artikelstammItem.getBlackBoxReason() != BlackBoxReason.NOT_BLACKBOXED || artikelstammItem.getType() != ArtikelstammConstants.TYPE.N)) continue;
                        foundItem = artikelstammItem;
                        log.warn("[II] isOddb2xml {} Selected ID [{}] of {} items to update.", new Object[]{isOddb2xml, foundItem.getId(), result.size()});
                        break;
                    }
                }
            }
            if (bPharma && item.getPHARMATYPE().contentEquals("P") || bNonPharma && item.getPHARMATYPE().contentEquals("N")) {
                boolean keepOverriddenPublicPrice = false;
                boolean keepOverriddenPkgSize = false;
                if (foundItem == null) {
                    String trimmedDscr = ArtikelstammImporter.trimDSCR(item.getDSCR(), item.getGTIN());
                    ArtikelstammConstants.TYPE pharmaType = ArtikelstammConstants.TYPE.X;
                    if (item.getPHARMATYPE() != null) {
                        String ptString = Character.toString(item.getPHARMATYPE().charAt(0));
                        pharmaType = ArtikelstammConstants.TYPE.valueOf((String)ptString.toUpperCase());
                    }
                    foundItem = new ArtikelstammItem(newVersion, pharmaType, item.getGTIN(), item.getPHAR(), trimmedDscr, "");
                    log.trace("[II] Adding article " + foundItem.getId() + " (" + item.getDSCR() + ")");
                } else {
                    keepOverriddenPublicPrice = foundItem.isUserDefinedPrice();
                    keepOverriddenPkgSize = foundItem.isUserDefinedPkgSize();
                }
                log.trace("[II] Updating article {} {}  {} {} ({})", new Object[]{item.getPHARMATYPE(), bPharma && item.getPHARMATYPE().contentEquals("P"), bNonPharma && item.getPHARMATYPE().contentEquals("N"), foundItem.getId()});
                ArtikelstammImporter.setValuesOnArtikelstammItem(foundItem, item, newVersion, keepOverriddenPublicPrice, keepOverriddenPkgSize);
            }
            subMonitor.worked(1);
        }
        subMonitor.done();
    }

    private static void setValuesOnArtikelstammItem(ArtikelstammItem ai, ARTIKELSTAMM.ITEMS.ITEM item, int cummulatedVersion, boolean keepOverriddenPublicPrice, boolean keepOverriddenPkgSize) {
        ARTIKELSTAMM.PRODUCTS.PRODUCT product;
        boolean oddb2xmlOverride;
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        fields.add("CUMM_VERSION");
        values.add(String.valueOf(cummulatedVersion));
        fields.add("PHAR");
        values.add(item.getPHAR() != null ? String.format("%07d", item.getPHAR()) : null);
        fields.add("BB");
        SALECDType salecd = item.getSALECD();
        boolean bl = oddb2xmlOverride = isOddb2xml && item.getPHARMATYPE().contentEquals("N");
        if (SALECDType.A == salecd || oddb2xmlOverride) {
            values.add(Integer.toString(BlackBoxReason.NOT_BLACKBOXED.getNumercialReason()));
            log.debug("{} Clearing blackboxed as salecd {} is A isSL {} or oddb2xml override {}", new Object[]{item.getGTIN(), salecd, item.isSLENTRY(), oddb2xmlOverride});
        } else {
            log.debug("{} Setting blackboxed as 5 {} != {} SALECDTypt.A  isSL {}", new Object[]{item.getGTIN(), salecd, SALECDType.A, salecd, item.isSLENTRY()});
            values.add(Integer.toString(BlackBoxReason.INACTIVE.getNumercialReason()));
        }
        fields.add("GTIN");
        values.add(item.getGTIN());
        fields.add("Typ");
        values.add(item.getPHARMATYPE().contentEquals("P") ? "P" : "N");
        fields.add("DSCR");
        values.add(ArtikelstammImporter.trimDSCR(item.getDSCR(), item.getGTIN()));
        ARTIKELSTAMM.PRODUCTS.PRODUCT pRODUCT = product = item.getPRODNO() != null ? products.get(item.getPRODNO()) : null;
        if (product == null) {
            product = new ARTIKELSTAMM.PRODUCTS.PRODUCT();
        }
        fields.add("ATC");
        values.add(product.getATC());
        fields.add("PRODNO");
        values.add(item.getPRODNO());
        String limnamebag = product.getLIMNAMEBAG();
        ARTIKELSTAMM.LIMITATIONS.LIMITATION limitation = null;
        Integer limitationPts = null;
        String limitationDscr = null;
        if (limnamebag != null && (limitation = limitations.get(limnamebag)) != null) {
            limitationPts = limitation.getLIMITATIONPTS();
            limitationDscr = limitation.getDSCR();
        }
        fields.add("LIMITATION");
        values.add(limitation != null ? "1" : "0");
        fields.add("LIMITIATION_PTS");
        values.add(limitationPts != null ? limitationPts.toString() : null);
        fields.add("LIMITATION_TXT");
        values.add(limitationDscr);
        String compName = null;
        String compGln = null;
        if (item.getCOMP() != null) {
            compName = item.getCOMP().getNAME();
            compGln = item.getCOMP().getGLN();
        }
        fields.add("COMP_NAME");
        values.add(compName);
        fields.add("COMP_GLN");
        values.add(compGln);
        fields.add("PEXF");
        values.add(item.getPEXF() != null ? item.getPEXF().toString() : null);
        if (!keepOverriddenPublicPrice) {
            fields.add("PPUB");
            values.add(item.getPPUB() != null ? item.getPPUB().toString() : null);
        } else if (item.getPPUB() != null) {
            ai.setExtInfoStoredObjectByKey("PPUB_OVERRIDE_STORE", item.getPPUB().toString());
            log.info("[II] [{}] Updating ppub override store to [{}]", (Object)ai.getId(), (Object)item.getPPUB());
        }
        fields.add("SL_ENTRY");
        values.add(item.isSLENTRY() != null && item.isSLENTRY() != false ? "1" : "0");
        fields.add("DEDUCTIBLE");
        values.add(item.getDEDUCTIBLE() != null ? item.getDEDUCTIBLE().toString() : null);
        fields.add("GENERIC_TYPE");
        values.add(item.getGENERICTYPE());
        fields.add("IKSCAT");
        values.add(item.getIKSCAT());
        fields.add("NARCOTIC");
        values.add(item.isNARCOTIC() != null && item.isNARCOTIC() != false ? "1" : "0");
        fields.add("LPPV");
        values.add(item.isLPPV() != null && item.isLPPV() != false ? "1" : "0");
        if (!keepOverriddenPkgSize) {
            fields.add("PKG_SIZE");
            String pkgSize = item.getPKGSIZE() != null ? item.getPKGSIZE().toString() : null;
            values.add(pkgSize != null && pkgSize.length() > 6 ? pkgSize.substring(0, 6).toString() : pkgSize);
            if (pkgSize != null && pkgSize.length() > 6) {
                log.warn("[II] Delimited pkg size for [{}] being [{}] to 6 characters.", (Object)ai.getId(), (Object)item.getPKGSIZE().toString());
            }
        } else if (item.getPKGSIZE() != null) {
            ai.setExtInfoStoredObjectByKey("PKG_SIZE_OVERRIDE_STORE", item.getPKGSIZE().toString());
            log.info("[II] [{}] Updating PKG_SIZE override store to [{}] fld {}", new Object[]{ai.getId(), item.getPKGSIZE(), ai.get("PKG_SIZE")});
        }
        ai.set(fields.toArray(new String[0]), values.toArray(new String[0]));
    }
}

