/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.atc_codes.internal;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.internal.ATCHierarchyComparator;
import at.medevit.atc_codes.parser.ATCDDDParser;
import at.medevit.atc_codes.parser.ATCParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ATCCodes {
    public static final String ATC_CODES_SERIALIZED_FILE = "/lib/ATCCodesMap.ser";
    private static ATCCodes instance = null;
    private HashMap<String, ATCCode> atcCodesMap = null;
    private ATCHierarchyComparator ahc = new ATCHierarchyComparator();

    private ATCCodes() {
        this.initHashMapFromSerializedObject();
    }

    public static ATCCodes getInstance() {
        if (instance == null) {
            instance = new ATCCodes();
        }
        return instance;
    }

    private void initHashMapFromSerializedObject() {
        try {
            InputStream is = ATCCodes.class.getResourceAsStream(ATC_CODES_SERIALIZED_FILE);
            if (is == null) {
                is = ATCCodes.class.getResourceAsStream("/ATCCodesMap.ser");
            }
            try (ObjectInputStream input = new ObjectInputStream(is);){
                this.atcCodesMap = (HashMap)input.readObject();
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    protected HashMap<String, ATCCode> getAtcCodesMap() {
        return this.atcCodesMap;
    }

    protected void initHashMap(List<ATCParser.ATCDefinition> atcDefinitions, HashMap<String, ATCDDDParser.ATCDDDDefinition> atcDDDDefinitions, HashMap<String, String> atcCodeToGerman) {
        this.atcCodesMap = new HashMap();
        for (ATCParser.ATCDefinition def : atcDefinitions) {
            ATCDDDParser.ATCDDDDefinition dddDef = atcDDDDefinitions.get(def.atcCode);
            int level = this.determineLevel(def.atcCode);
            float ddd = 0.0f;
            ATCCode.DDD_UNIT_TYPE dddUt = null;
            String dddAc = null;
            String dddComment = null;
            if (dddDef != null) {
                float f = ddd = dddDef.ddd != null && dddDef.ddd.length() > 0 ? Float.parseFloat(dddDef.ddd) : 0.0f;
                if (dddDef.unitType != null) {
                    dddUt = ATCCode.DDD_UNIT_TYPE.valueOf(dddDef.unitType.toUpperCase());
                }
                if (dddDef.admCode != null) {
                    dddAc = dddDef.admCode;
                }
                if (dddDef.dddComment != null) {
                    dddComment = dddDef.dddComment;
                }
            }
            String germanName = atcCodeToGerman.get(def.atcCode);
            ATCCode c = new ATCCode(def.atcCode, def.name, germanName, level, ddd, dddUt, dddAc, dddComment);
            this.atcCodesMap.put(def.atcCode, c);
        }
    }

    private int determineLevel(String atcCode) {
        switch (atcCode.length()) {
            case 7: {
                return 5;
            }
            case 5: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    protected void readXMLFile(File inFile, DefaultHandler parser) throws IOException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(parser);
            xr.setErrorHandler(parser);
            FileReader fr = new FileReader(inFile);
            xr.parse(new InputSource(fr));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public ATCCode getATCCode(String atcCode) {
        return this.atcCodesMap.get(atcCode.trim());
    }

    public List<ATCCode> getATCCodesMatchingName(String name, int language, int matchType) {
        ArrayList<ATCCode> ret = new ArrayList<ATCCode>();
        Collection<ATCCode> values = this.atcCodesMap.values();
        if (matchType == 0) {
            this.matchByNameOnly(ret, values, language, name);
        } else {
            this.matchByNameOrATC(ret, values, language, name);
        }
        this.orderByATCHierarchy(ret);
        return ret;
    }

    private void orderByATCHierarchy(List<ATCCode> ret) {
        Collections.sort(ret, this.ahc);
    }

    private void matchByNameOrATC(List<ATCCode> ret, Collection<ATCCode> values, int language, String name) {
        if (language == 1) {
            for (ATCCode atcCode : values) {
                if (atcCode.name_german != null && atcCode.name_german.toLowerCase().contains(name.toLowerCase()) || atcCode.atcCode.contains(name)) {
                    ret.add(atcCode);
                    continue;
                }
                if (atcCode.name == null || !atcCode.name.toLowerCase().contains(name.toLowerCase())) continue;
                ret.add(atcCode);
            }
        } else {
            for (ATCCode atcCode : values) {
                if (atcCode.name == null || !atcCode.name.toLowerCase().contains(name.toLowerCase())) continue;
                ret.add(atcCode);
            }
        }
    }

    private void matchByNameOnly(List<ATCCode> ret, Collection<ATCCode> values, int language, String name) {
        if (language == 1) {
            for (ATCCode atcCode : values) {
                if (atcCode.name_german != null && atcCode.name_german.toLowerCase().contains(name.toLowerCase())) {
                    ret.add(atcCode);
                    continue;
                }
                if (atcCode.name == null || !atcCode.name.toLowerCase().contains(name.toLowerCase())) continue;
                ret.add(atcCode);
            }
        } else {
            for (ATCCode atcCode : values) {
                if (atcCode.name == null || !atcCode.name.toLowerCase().contains(name.toLowerCase())) continue;
                ret.add(atcCode);
            }
        }
    }

    public List<ATCCode> getAllATCCodes() {
        ArrayList<ATCCode> list = new ArrayList<ATCCode>(this.atcCodesMap.values());
        this.orderByATCHierarchy(list);
        return Collections.unmodifiableList(list);
    }
}

