/*
 * Decompiled with CFR 0.152.
 */
package at.gruber.elexis.mythic22.inputhandler;

import at.gruber.elexis.mythic22.model.HaematologicalValue;
import at.gruber.elexis.mythic22.model.Mythic22Result;
import java.util.HashMap;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputHandler {
    private static Logger logger = LoggerFactory.getLogger(InputHandler.class);
    private HashMap<String, String> m_inputMap = new HashMap();
    private static InputHandler m_instance = null;

    public static InputHandler getInstance() {
        if (m_instance == null) {
            m_instance = new InputHandler();
        }
        return m_instance;
    }

    private InputHandler() {
        String s;
        String[] stringArray = Mythic22Result.FIELDS;
        int n = Mythic22Result.FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.m_inputMap.put(s, "");
            ++n2;
        }
        stringArray = Mythic22Result.HAEMATOLOGICALFIELDS;
        n = Mythic22Result.HAEMATOLOGICALFIELDS.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.m_inputMap.put(s, "");
            ++n2;
        }
    }

    public Mythic22Result processInput(String input) {
        this.fillInputMap(input);
        return this.genereateMythic22Result();
    }

    private void fillInputMap(String input) {
        String processedInput = this.processMatrices(input);
        String[] lines = processedInput.split("\n");
        lines[0] = lines[0].replaceFirst(" ", ";");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String key = line.substring(0, line.indexOf(";"));
            String value = line.substring(line.indexOf(";") + 1);
            this.m_inputMap.put(key, value);
            ++n2;
        }
    }

    private String processMatrices(String input) {
        try {
            String lmneMatrix = input.substring(input.indexOf("LMNE MATRIX"), input.indexOf(";T\n", input.indexOf("LMNE MATRIX")));
            String lmneShadeMatrix = input.substring(input.indexOf("LMNE SHADE MATRIX"), input.indexOf(";T\n", input.indexOf("LMNE SHADE MATRIX")));
            int endIndex = this.getIndexof(input, "\n", input.indexOf("THRES 5D LMNE MATRIX"), 3);
            String thres5dLmneMatrix = input.substring(input.indexOf("THRES 5D LMNE MATRIX"), endIndex);
            input = input.replaceFirst(String.valueOf(lmneMatrix) + ";T\n", "");
            input = input.replaceFirst(String.valueOf(lmneShadeMatrix) + ";T\n", "");
            input = input.replaceFirst(String.valueOf(thres5dLmneMatrix) + '\n', "");
            this.m_inputMap.put("LMNE MATRIX", lmneMatrix.substring(lmneMatrix.indexOf(10) + 1));
            this.m_inputMap.put("LMNE SHADE MATRIX", lmneMatrix.substring(lmneMatrix.indexOf(10) + 1));
            this.m_inputMap.put("THRES 5D LMNE MATRIX", lmneMatrix.substring(thres5dLmneMatrix.indexOf(10) + 1));
        }
        catch (IndexOutOfBoundsException e) {
            logger.error("index error while processing matrix", (Throwable)e);
        }
        return input;
    }

    private int getIndexof(String str, String regex, int fromIndex, int occurrences) {
        int returnIndex = fromIndex;
        int i = 0;
        while (i < 3) {
            returnIndex = str.indexOf(regex, returnIndex + 1);
            ++i;
        }
        return returnIndex;
    }

    private Mythic22Result genereateMythic22Result() {
        String field;
        LinkedList<HaematologicalValue> haemaValuesList = new LinkedList<HaematologicalValue>();
        HashMap<String, LinkedList<String>> defaultValuesList = new HashMap<String, LinkedList<String>>();
        String[] stringArray = Mythic22Result.HAEMATOLOGICALFIELDS;
        int n = Mythic22Result.HAEMATOLOGICALFIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            field = stringArray[n2];
            haemaValuesList.add(new HaematologicalValue(field, this.m_inputMap.get(field)));
            ++n2;
        }
        stringArray = Mythic22Result.FIELDS;
        n = Mythic22Result.FIELDS.length;
        n2 = 0;
        while (n2 < n) {
            field = stringArray[n2];
            defaultValuesList.put(field, this.createValuesList(this.m_inputMap.get(field)));
            ++n2;
        }
        return new Mythic22Result(haemaValuesList, defaultValuesList);
    }

    private LinkedList<String> createValuesList(String csvString) {
        String[] temp = csvString.split(";");
        LinkedList<String> returnList = new LinkedList<String>();
        String[] stringArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            returnList.add(s.trim());
            ++n2;
        }
        return returnList;
    }

    public HashMap<String, String> getInputMap() {
        return this.m_inputMap;
    }
}

